(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    113438,       4875]*)
(*NotebookOutlinePosition[    114577,       4912]*)
(*  CellTagsIndexPosition[    114533,       4908]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["How Hard is Factoring on a Classical Computer?", "Title",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Colin P. Williams ", "Subsubtitle",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Off[General::spell1]\)], "Input",
  InitializationCell->True],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
%% Graphics
/Courier findfont 8  scalefont  setfont
% Scaling calculations
-0.656463 0.0340136 0.727124 0.231363 [
[(20)] .02381 0 0 2 0 Minner Mrotsboxa
[(25)] .19388 0 0 2 0 Minner Mrotsboxa
[(30)] .36395 0 0 2 0 Minner Mrotsboxa
[(35)] .53401 0 0 2 0 Minner Mrotsboxa
[(40)] .70408 0 0 2 0 Minner Mrotsboxa
[(45)] .87415 0 0 2 0 Minner Mrotsboxa
[(Size of n)] .5 0 0 2 0 0 -1 Mouter Mrotsboxa
[(0.001)] -0.0125 .03303 1 0 0 Minner Mrotsboxa
[(0.005)] -0.0125 .19475 1 0 0 Minner Mrotsboxa
[(0.01)] -0.0125 .2644 1 0 0 Minner Mrotsboxa
[(0.05)] -0.0125 .42611 1 0 0 Minner Mrotsboxa
[(0.1)] -0.0125 .49576 1 0 0 Minner Mrotsboxa
[(Time to Find Factors of n)] -0.0125 .30902 1 0 90 -1 0 Mouter Mrotsboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 .61903 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
0 0 .5 r
.001 w
.19388 0 m
.19388 .61803 L
s
P
p
0 0 .5 r
.001 w
.36395 0 m
.36395 .61803 L
s
P
p
0 0 .5 r
.001 w
.53401 0 m
.53401 .61803 L
s
P
p
0 0 .5 r
.001 w
.70408 0 m
.70408 .61803 L
s
P
p
0 0 .5 r
.001 w
.87415 0 m
.87415 .61803 L
s
P
p
0 0 .5 r
.001 w
0 .03303 m
1 .03303 L
s
P
p
0 0 .5 r
.001 w
0 .19475 m
1 .19475 L
s
P
p
0 0 .5 r
.001 w
0 .2644 m
1 .2644 L
s
P
p
0 0 .5 r
.001 w
0 .42611 m
1 .42611 L
s
P
p
0 0 .5 r
.001 w
0 .49576 m
1 .49576 L
s
P
p
0 0 .5 r
.001 w
0 .10268 m
1 .10268 L
s
P
p
0 0 .5 r
.001 w
0 .14342 m
1 .14342 L
s
P
p
0 0 .5 r
.001 w
0 .17233 m
1 .17233 L
s
P
p
0 0 .5 r
.001 w
0 .21307 m
1 .21307 L
s
P
p
0 0 .5 r
.001 w
0 .22856 m
1 .22856 L
s
P
p
0 0 .5 r
.001 w
0 .24198 m
1 .24198 L
s
P
p
0 0 .5 r
.001 w
0 .25381 m
1 .25381 L
s
P
p
0 0 .5 r
.001 w
0 .33405 m
1 .33405 L
s
P
p
0 0 .5 r
.001 w
0 .37479 m
1 .37479 L
s
P
p
0 0 .5 r
.001 w
0 .40369 m
1 .40369 L
s
P
p
0 0 .5 r
.001 w
0 .44443 m
1 .44443 L
s
P
p
0 0 .5 r
.001 w
0 .45992 m
1 .45992 L
s
P
p
0 0 .5 r
.001 w
0 .47334 m
1 .47334 L
s
P
p
0 0 .5 r
.001 w
0 .48517 m
1 .48517 L
s
P
p
0 0 .5 r
.001 w
0 .56541 m
1 .56541 L
s
P
p
0 0 .5 r
.001 w
0 .60615 m
1 .60615 L
s
P
p
.002 w
.02381 0 m
.02381 .00625 L
s
P
[(20)] .02381 0 0 2 0 Minner Mrotshowa
p
.002 w
.19388 0 m
.19388 .00625 L
s
P
[(25)] .19388 0 0 2 0 Minner Mrotshowa
p
.002 w
.36395 0 m
.36395 .00625 L
s
P
[(30)] .36395 0 0 2 0 Minner Mrotshowa
p
.002 w
.53401 0 m
.53401 .00625 L
s
P
[(35)] .53401 0 0 2 0 Minner Mrotshowa
p
.002 w
.70408 0 m
.70408 .00625 L
s
P
[(40)] .70408 0 0 2 0 Minner Mrotshowa
p
.002 w
.87415 0 m
.87415 .00625 L
s
P
[(45)] .87415 0 0 2 0 Minner Mrotshowa
p
.001 w
.05782 0 m
.05782 .00375 L
s
P
p
.001 w
.09184 0 m
.09184 .00375 L
s
P
p
.001 w
.12585 0 m
.12585 .00375 L
s
P
p
.001 w
.15986 0 m
.15986 .00375 L
s
P
p
.001 w
.22789 0 m
.22789 .00375 L
s
P
p
.001 w
.2619 0 m
.2619 .00375 L
s
P
p
.001 w
.29592 0 m
.29592 .00375 L
s
P
p
.001 w
.32993 0 m
.32993 .00375 L
s
P
p
.001 w
.39796 0 m
.39796 .00375 L
s
P
p
.001 w
.43197 0 m
.43197 .00375 L
s
P
p
.001 w
.46599 0 m
.46599 .00375 L
s
P
p
.001 w
.5 0 m
.5 .00375 L
s
P
p
.001 w
.56803 0 m
.56803 .00375 L
s
P
p
.001 w
.60204 0 m
.60204 .00375 L
s
P
p
.001 w
.63605 0 m
.63605 .00375 L
s
P
p
.001 w
.67007 0 m
.67007 .00375 L
s
P
p
.001 w
.7381 0 m
.7381 .00375 L
s
P
p
.001 w
.77211 0 m
.77211 .00375 L
s
P
p
.001 w
.80612 0 m
.80612 .00375 L
s
P
p
.001 w
.84014 0 m
.84014 .00375 L
s
P
p
.001 w
.90816 0 m
.90816 .00375 L
s
P
p
.001 w
.94218 0 m
.94218 .00375 L
s
P
p
.001 w
.97619 0 m
.97619 .00375 L
s
P
[(Size of n)] .5 0 0 2 0 0 -1 Mouter Mrotshowa
p
.002 w
0 0 m
1 0 L
s
P
p
.002 w
0 .03303 m
.00625 .03303 L
s
P
[(0.001)] -0.0125 .03303 1 0 0 Minner Mrotshowa
p
.002 w
0 .19475 m
.00625 .19475 L
s
P
[(0.005)] -0.0125 .19475 1 0 0 Minner Mrotshowa
p
.002 w
0 .2644 m
.00625 .2644 L
s
P
[(0.01)] -0.0125 .2644 1 0 0 Minner Mrotshowa
p
.002 w
0 .42611 m
.00625 .42611 L
s
P
[(0.05)] -0.0125 .42611 1 0 0 Minner Mrotshowa
p
.002 w
0 .49576 m
.00625 .49576 L
s
P
[(0.1)] -0.0125 .49576 1 0 0 Minner Mrotshowa
p
.001 w
0 .10268 m
.00375 .10268 L
s
P
p
.001 w
0 .14342 m
.00375 .14342 L
s
P
p
.001 w
0 .17233 m
.00375 .17233 L
s
P
p
.001 w
0 .21307 m
.00375 .21307 L
s
P
p
.001 w
0 .22856 m
.00375 .22856 L
s
P
p
.001 w
0 .24198 m
.00375 .24198 L
s
P
p
.001 w
0 .25381 m
.00375 .25381 L
s
P
p
.001 w
0 .33405 m
.00375 .33405 L
s
P
p
.001 w
0 .37479 m
.00375 .37479 L
s
P
p
.001 w
0 .40369 m
.00375 .40369 L
s
P
p
.001 w
0 .44443 m
.00375 .44443 L
s
P
p
.001 w
0 .45992 m
.00375 .45992 L
s
P
p
.001 w
0 .47334 m
.00375 .47334 L
s
P
p
.001 w
0 .48517 m
.00375 .48517 L
s
P
p
.001 w
0 .56541 m
.00375 .56541 L
s
P
p
.001 w
0 .60615 m
.00375 .60615 L
s
P
[(Time to Find Factors of n)] -0.0125 .30902 1 0 90 -1 0 Mouter Mrotshowa
p
.002 w
0 0 m
0 .61803 L
s
P
P
p
p
.002 w
.02381 .61178 m
.02381 .61803 L
s
P
p
.002 w
.19388 .61178 m
.19388 .61803 L
s
P
p
.002 w
.36395 .61178 m
.36395 .61803 L
s
P
p
.002 w
.53401 .61178 m
.53401 .61803 L
s
P
p
.002 w
.70408 .61178 m
.70408 .61803 L
s
P
p
.002 w
.87415 .61178 m
.87415 .61803 L
s
P
p
.001 w
.05782 .61428 m
.05782 .61803 L
s
P
p
.001 w
.09184 .61428 m
.09184 .61803 L
s
P
p
.001 w
.12585 .61428 m
.12585 .61803 L
s
P
p
.001 w
.15986 .61428 m
.15986 .61803 L
s
P
p
.001 w
.22789 .61428 m
.22789 .61803 L
s
P
p
.001 w
.2619 .61428 m
.2619 .61803 L
s
P
p
.001 w
.29592 .61428 m
.29592 .61803 L
s
P
p
.001 w
.32993 .61428 m
.32993 .61803 L
s
P
p
.001 w
.39796 .61428 m
.39796 .61803 L
s
P
p
.001 w
.43197 .61428 m
.43197 .61803 L
s
P
p
.001 w
.46599 .61428 m
.46599 .61803 L
s
P
p
.001 w
.5 .61428 m
.5 .61803 L
s
P
p
.001 w
.56803 .61428 m
.56803 .61803 L
s
P
p
.001 w
.60204 .61428 m
.60204 .61803 L
s
P
p
.001 w
.63605 .61428 m
.63605 .61803 L
s
P
p
.001 w
.67007 .61428 m
.67007 .61803 L
s
P
p
.001 w
.7381 .61428 m
.7381 .61803 L
s
P
p
.001 w
.77211 .61428 m
.77211 .61803 L
s
P
p
.001 w
.80612 .61428 m
.80612 .61803 L
s
P
p
.001 w
.84014 .61428 m
.84014 .61803 L
s
P
p
.001 w
.90816 .61428 m
.90816 .61803 L
s
P
p
.001 w
.94218 .61428 m
.94218 .61803 L
s
P
p
.001 w
.97619 .61428 m
.97619 .61803 L
s
P
p
.002 w
0 .61803 m
1 .61803 L
s
P
p
.002 w
.99375 .03303 m
1 .03303 L
s
P
p
.002 w
.99375 .19475 m
1 .19475 L
s
P
p
.002 w
.99375 .2644 m
1 .2644 L
s
P
p
.002 w
.99375 .42611 m
1 .42611 L
s
P
p
.002 w
.99375 .49576 m
1 .49576 L
s
P
p
.001 w
.99625 .10268 m
1 .10268 L
s
P
p
.001 w
.99625 .14342 m
1 .14342 L
s
P
p
.001 w
.99625 .17233 m
1 .17233 L
s
P
p
.001 w
.99625 .21307 m
1 .21307 L
s
P
p
.001 w
.99625 .22856 m
1 .22856 L
s
P
p
.001 w
.99625 .24198 m
1 .24198 L
s
P
p
.001 w
.99625 .25381 m
1 .25381 L
s
P
p
.001 w
.99625 .33405 m
1 .33405 L
s
P
p
.001 w
.99625 .37479 m
1 .37479 L
s
P
p
.001 w
.99625 .40369 m
1 .40369 L
s
P
p
.001 w
.99625 .44443 m
1 .44443 L
s
P
p
.001 w
.99625 .45992 m
1 .45992 L
s
P
p
.001 w
.99625 .47334 m
1 .47334 L
s
P
p
.001 w
.99625 .48517 m
1 .48517 L
s
P
p
.001 w
.99625 .56541 m
1 .56541 L
s
P
p
.001 w
.99625 .60615 m
1 .60615 L
s
P
p
.002 w
1 0 m
1 .61803 L
s
P
P
p
P
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
p
p
.02 w
.02381 .08436 Mdot
.15986 .01472 Mdot
.29592 .08436 Mdot
.43197 .28682 Mdot
.56803 .2994 Mdot
.70408 .42443 Mdot
.84014 .45248 Mdot
.97619 .60332 Mdot
P
P
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{245, 151},
  ImageMargins->{{34, Inherited}, {Inherited, Inherited}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003e0000Ua000`40O003h00OmGoo003eOol00?Eo
o`00mGoo001dOol9000017oo000000000Woo0`001goo0P000Woo10001Goo00<007oo0000F7oo001d
Ool01000Oomoo`000Woo00@007ooOomoo`80009oo`03001oogoo00Moo`04001oogoo0002Ool00`00
Oomoo`05Ool00`00Ool0001HOol007Eoo`8000=oo`03001oogoo009oo`800003Ool00000008000Io
o`04001oogoo0002Ool00`00Oomoo`05Ool00`00Ool0001HOol007Aoo`05001oogoo001oo`020003
Ool30002Ool20008Ool20002Ool40004Ool4001HOol007Aoo`@001Yoo`03001oogoo061oo`00NWoo
00<007ooOol05Goo0`00H7oo003eOol00?Eoo`00mGoo003eOol00?Eoo`00mGoo003eOol00?Eoo`00
9Woo0`000goo00<007ooOol06Goo0`000Woo0`006Woo0`000goo00<007ooOol06Goo0`000Woo0`00
77oo00D007ooOomoo`0001eoo`03001oogoo00<001eoo`009goo00L007ooOomoo`00Ool0000KOol0
0`00Oomoo`03Ool00`00Oomoo`0JOol01P00Oomoo`00Ool001aoo`03001oogoo009oo`03001oogoo
01Qoo`<0009oo`03001oo`0001Yoo`<000Aoo`03001oogoo01]oo`00:7oo00H007ooOol007oo000L
Ool00`00Oomoo`03000KOol01`00Oomoogoo001oo`0001]oo`04001oogooOol3000JOol00`00Ool0
0002Ool00`00Ool0000JOol00`00Ool00002Ool3000MOol002Qoo`06001oogoo001oo`0077oo00@0
07ooOol001ioo`06001oogoo001oo`0077oo00@007ooOol001eoo`80009oo`03001oo`0001]oo`80
009oo`03001oogoo01eoo`009Woo0`000goo00<007ooOol06Goo0`000Woo0`006Woo0`000goo00<0
07ooOol06Goo0`000Woo0`0077oo00D007ooOomoo`0001eoo`03001oogoo00<001eoo`00mGoo003e
Ool00?Eoo`00mGoo000UOoo90007Ool002Eoo`03001oogoo009oo`03001oogoo01Moo`8000Ioo`03
001oogoo01moo`03001oogoo01moo`03001oogoo01moo`03001oogoo01moo`03001oogoo01Ioo`03
001oogoo00Eoo`009Goo00<007ooOol06goo10001Goo00<03gooOol07goo00<03gooOol07goo00<0
3gooOol07goo00<03gooOol07goo00<03gooOol05Woo00<007ooOol01Goo0007Ool3000KOol00`00
Oomoo`0KOol40005Ool00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0O
Ool00`0?Oomoo`0FOol00`00Oomoo`05Ool000Qoo`03001oogoo01Yoo`03001oogoo01aoo`8000Io
o`0300moogoo01moo`0300moogoo01moo`0300moogoo01moo`0300moogoo01moo`0300moogoo01Io
o`03001oogoo00Eoo`0027oo00<007ooOol00Woo00<007ooOol00Woo00<007ooOol00Woo00D007oo
Oomoo`0000=oo`<000=oo`03001oogoo02Aoo`0300moogoo01moo`0300moogoo01moo`0300moogoo
01moo`0300moogoo01moo`0300moogoo01Ioo`03001oogoo00Eoo`001Woo00T007oo001oo`00Ool0
07oo00001goo00L007oo001oo`00Ool00003Ool00`00Oomoo`02Ool2003500l20007Ool000Ioo`D0
0004Ool007oo0007Ool01`00Ool007oo001oo`0000=oo`03001oogoo009oo`03001oogoo02Aoo`03
00moogoo01moo`0300moogoo01moo`0300moogoo01moo`0300moogoo01moo`0300moogoo01Ioo`03
001oogoo00Eoo`001Woo1@0000Aoo`00Ool000Moo`07001oo`00Ool007oo00000goo00<007ooOol0
0Woo00<007ooOol097oo00<03gooOol07goo00<03gooOol07goo00<03gooOol07goo00<03gooOol0
7goo00<03gooOol05Woo00<007ooOol01Goo0008Ool00`00Oomoo`02Ool00`00Oomoo`07Ool01@00
Oomoogoo00000goo0P0017oo00<007ooOol097oo00<03gooOol07goo00<03gooOol07goo00<03goo
Ool07goo00<03gooOol07goo00<03gooOol05Woo00<007ooOol01Goo0008Ool00`00Oomoo`0JOol0
0`00Oomoo`0TOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol0
0`0?Oomoo`0FOol00`00Oomoo`05Ool000Moo`8001aoo`03001oogoo02Aoo`0300moogoo01moo`03
00moogoo01moo`0300moogoo01moo`0300moogoo01moo`0300moogoo01Ioo`03001oogoo00Eoo`00
1Woo00D007oo001oo`0001Yoo`03001oogoo02Aoo`0300moogoo01moo`0300moogoo01moo`0300mo
ogoo01moo`0300moogoo01moo`0300moogoo01Ioo`03001oogoo00Eoo`001Woo00D007oo001oo`00
01Yoo`03001oogoo02Aoo`0300moogoo01moo`0300moogoo01moo`0300moogoo01moo`0300moogoo
01moo`0300moogoo01Ioo`03001oogoo00Eoo`001Woo00D007oo001oo`0001Yoo`03001oogoo02Ao
o`0300moogoo01moo`0300moogoo01moo`0300moogoo01moo`0300moogoo01moo`0300moogoo01Io
o`03001oogoo00Eoo`001Woo1@006Woo00@007ooOomoo`80025oo`0300moogoo015oo`8000aoo`03
00moogoo01moo`0300moogoo01moo`0300moogoo01moo`0300moogoo01Ioo`03001oogoo00Eoo`00
9Goo00<007ooOol0100087oo00<03gooOol047oo10002goo00<03gooOol07goo00<03gooOol07goo
00<03gooOol07goo00<03gooOol05Woo00<007ooOol01Goo0008Ool3000JOol00`00Oomoo`04000P
Ool00`0?Oomoo`0@Ool4000;Ool00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?
Oomoo`0FOol00`00Oomoo`05Ool000Moo`03001oogoo01]oo`04001oogooOol2000QOol00`0?Oomo
o`0AOol2000<Ool00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0FOol0
0`00Oomoo`05Ool000Moo`@001Yoo`03001oogoo02Aoo`0300moogoo01moo`0300moogoo01moo`03
00moogoo01moo`0300moogoo01moo`0300moogoo01Ioo`03001oogoo00Eoo`0027oo0P006goo0P00
a@0?0P001goo000UOol00`00Oomoo`0TOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0O
Ool00`0?Oomoo`0OOol00`0?Oomoo`0FOol00`00Oomoo`05Ool002Eoo`03001oogoo02Aoo`0300mo
ogoo01moo`0300moogoo01moo`0300moogoo01moo`0300moogoo01moo`0300moogoo01Ioo`03001o
ogoo00Eoo`009Goo00<007ooOol097oo00<03gooOol07goo00<03gooOol07goo00<03gooOol07goo
00<03gooOol07goo00<03gooOol05Woo00<007ooOol01Goo000UOol00`00Oomoo`0TOol00`0?Oomo
o`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0FOol00`00Oomo
o`05Ool002Eoo`03001oogoo02Aoo`0300moogoo01moo`0300moogoo01moo`0300moogoo01moo`03
00moogoo01moo`0300moogoo01Ioo`03001oogoo00Eoo`009Goo00<007ooOol097oo00<03gooOol0
7goo00<03gooOol07goo00<03gooOol07goo00<03gooOol07goo00<03gooOol05Woo00<007ooOol0
1Goo0007Ool3000KOol00`00Oomoo`0TOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0O
Ool00`0?Oomoo`0OOol00`0?Oomoo`0FOol00`00Oomoo`05Ool000Moo`03001oogoo01]oo`800<D0
3`8000Moo`001goo00<007ooOol06goo00<007ooOol097oo00<03gooOol07goo00<03gooOol07goo
00<03gooOol07goo00<03gooOol07goo00<03gooOol05Woo00<007ooOol01Goo0006Ool4000KOol0
0`00Oomoo`0TOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol0
0`0?Oomoo`0FOol00`00Oomoo`05Ool000Moo`03001oogoo01]oo`03001oogoo02Aoo`0300moogoo
01moo`0300moogoo01moo`0300moogoo01moo`0300moogoo01moo`0300moogoo01Ioo`03001oogoo
00Eoo`0027oo0P006goo00<007ooOol097oo00<03gooOol07goo00<03gooOol07goo00<03gooOol0
7goo00<03gooOol07goo00<03gooOol05Woo00<007ooOol01Goo0007Ool01000Oomoo`006Woo00<0
07ooOol097oo00<03gooOol07goo00<03gooOol07goo00<03gooOol07goo00<03gooOol07goo00<0
3gooOol05Woo00<007ooOol01Goo0007Ool01000Oomoo`006Woo0P00a@0?0P001goo0008Ool2000K
Ool00`00Oomoo`0TOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0O
Ool00`0?Oomoo`0FOol00`00Oomoo`05Ool002Eoo`03001oogoo02Aoo`0300moogoo01moo`0300mo
ogoo01moo`0300moogoo01moo`0300moogoo01moo`0300moogoo01Ioo`03001oogoo00Eoo`009Goo
00<007ooOol097oo00<03gooOol07goo00<03gooOol07goo00<03gooOol07goo00<03gooOol07goo
00<03gooOol05Woo00<007ooOol01Goo000=Ool00`00Oomoo`02Ool00`00Oomoo`02Ool01@00Oomo
ogoo00000goo0`000goo00<007ooOol097oo00<03gooOol07goo00<03gooOol07goo00<03gooOol0
7goo00<03gooOol07goo00<03gooOol05Woo00<007ooOol01Goo000<Ool00`00Ool00007Ool01`00
Ool007oo001oo`0000Aoo`04001oogooOol2003500l20007Ool000aoo`03001oo`0000Moo`07001o
o`00Ool007oo00000Woo0`000goo00<007ooOol097oo00<03gooOol07goo00<03gooOol07goo00<0
3gooOol07goo00<03gooOol07goo00<03gooOol05Woo00<007ooOol01Goo0006Ool30003Ool00`00
Ool00007Ool01`00Ool007oo001oo`00009oo`03001oogoo00=oo`03001oogoo02Aoo`0300moogoo
01moo`0300moogoo01moo`0300moogoo01moo`0300moogoo01moo`0300moogoo01Ioo`03001oogoo
00Eoo`001goo00<007ooOol00goo00<007ooOol01goo00D007ooOomoo`0000=oo`<000=oo`800<D0
3`8000Moo`001goo0`006goo00<007ooOol097oo00<03gooOol07goo00<03gooOol07goo00<03goo
Ool07goo00<03gooOol07goo00<03gooOol05Woo00<007ooOol01Goo0007Ool00`00Oomoo`0KOol0
0`00Oomoo`0TOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol0
0`0?Oomoo`0FOol00`00Oomoo`05Ool000Ioo`@001]oo`800<D03`8000Moo`001Woo1@006Woo00<0
07ooOol097oo00<03gooOol07goo00<03gooOol07goo00<03gooOol07goo00<03gooOol07goo00<0
3gooOol05Woo00<007ooOol01Goo0008Ool00`00Oomoo`0JOol00`00Oomoo`0TOol00`0?Oomoo`0O
Ool00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0FOol00`00Oomoo`05
Ool000Qoo`03001oogoo01Yoo`800<D03`8000Moo`001goo0P0077oo00<007ooOol097oo00<03goo
Ool07goo00<03gooOol07goo00<03gooOol07goo00<03gooOol07goo00<03gooOol05Woo00<007oo
Ool01Goo000UOol2003500l20007Ool000Moo`<001]oo`03001oogoo02Aoo`0300moogoo01moo`03
00moogoo01moo`0300moogoo01moo`0300moogoo01moo`0300moogoo01Ioo`03001oogoo00Eoo`00
1goo00<007oo00001goo00<007ooOol00Woo00<007ooOol00Woo00<007ooOol00`0017oo00<007oo
Ool097oo00<03gooOol07goo00<03gooOol07goo00<03gooOol07goo00<03gooOol07goo00<03goo
Ool05Woo00<007ooOol01Goo0007Ool00`00Ool00006Ool00`00Ool00007Ool00`00Ool00002Ool0
0`00Oomoo`03Ool2003500l20007Ool000Ioo`@000Ioo`03001oo`0000Moo`03001oo`00009oo`03
001oogoo00=oo`03001oogoo02Aoo`0300moogoo01moo`0300moogoo01moo`0300moogoo01moo`03
00moogoo01moo`0300moogoo01Ioo`03001oogoo00Eoo`0047oo00<007oo00001goo00<007oo0000
0Woo00<007ooOol00goo00<007ooOol097oo00<03gooOol07goo00<03gooOol07goo00<03gooOol0
7goo00<03gooOol07goo00<03gooOol05Woo00<007ooOol01Goo0008Ool30006Ool00`00Oomoo`07
Ool00`00Oomoo`020005Ool00`00Oomoo`0TOol00`0?Oomoo`0OOol00`0?Oomoo`0:Ool2000COol0
0`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0FOol00`00Oomoo`05Ool000Moo`04001oogoo
000JOol00`00Oomoo`0TOol00`0?Oomoo`0OOol00`0?Oomoo`09Ool4000BOol00`0?Oomoo`0OOol0
0`0?Oomoo`0OOol00`0?Oomoo`0FOol00`00Oomoo`05Ool000Moo`04001oogoo000JOol00`00Oomo
o`0TOol00`0?Oomoo`0OOol00`0?Oomoo`09Ool4000BOol00`0?Oomoo`03Ool2000JOol00`0?Oomo
o`0OOol00`0?Oomoo`0FOol00`00Oomoo`05Ool000Qoo`<001Yoo`03001oogoo02Aoo`0300moogoo
01moo`0300moogoo00Yoo`8001=oo`0300moogoo009oo`@001Uoo`0300moogoo01moo`0300moogoo
01Ioo`03001oogoo00Eoo`002Woo00<007ooOol067oo00<007ooOol097oo00<03gooOol07goo00<0
3gooOol07goo00<03gooOol00Woo10006Goo00<03gooOol07goo00<03gooOol05Woo00<007ooOol0
1Goo000:Ool00`00Oomoo`0HOol00`00Oomoo`0TOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?
Oomoo`03Ool2000JOol00`0?Oomoo`0OOol00`0?Oomoo`0FOol00`00Oomoo`05Ool002Eoo`03001o
ogoo02Aoo`0300moogoo01moo`0300moogoo01moo`0300moogoo01moo`0300moogoo01moo`0300mo
ogoo01Ioo`03001oogoo00Eoo`009Goo00<007ooOol097oo00<03gooOol07goo00<03gooOol07goo
00<03gooOol07goo00<03gooOol07goo00<03gooOol05Woo00<007ooOol01Goo000UOol00`00Oomo
o`0TOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomo
o`0FOol00`00Oomoo`05Ool000Ioo`<001aoo`03001oogoo02Aoo`0300moogoo01moo`0300moogoo
01moo`0300moogoo01moo`0300moogoo01moo`0300moogoo01Ioo`03001oogoo00Eoo`001goo00<0
07ooOol06goo0P00a@0?0P001goo0007Ool3000KOol00`00Oomoo`0TOol00`0?Oomoo`0OOol00`0?
Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0FOol00`00Oomoo`05Ool000Mo
o`03001oogoo01]oo`03001oogoo02Aoo`0300moogoo01moo`0300moogoo01moo`0300moogoo01mo
o`0300moogoo01moo`0300moogoo01Ioo`03001oogoo00Eoo`001Woo10006goo00<007ooOol097oo
00<03gooOol07goo00<03gooOol07goo00<03gooOol07goo00<03gooOol07goo00<03gooOol05Woo
00<007ooOol01Goo0007Ool3000KOol00`00Oomoo`0TOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol0
0`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0FOol00`00Oomoo`05Ool000Moo`<001]oo`03
001oogoo02Aoo`0300moogoo01moo`0300moogoo01moo`0300moogoo01moo`0300moogoo01moo`03
00moogoo01Ioo`03001oogoo00Eoo`002Goo00<007ooOol06Goo00<007ooOol097oo00<03gooOol0
7goo00<03gooOol07goo00<03gooOol07goo00<03gooOol07goo00<03gooOol05Woo00<007ooOol0
1Goo0007Ool3000KOol00`00Oomoo`0TOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0O
Ool00`0?Oomoo`0OOol00`0?Oomoo`0FOol00`00Oomoo`05Ool002Eoo`03001oogoo02Aoo`0300mo
ogoo01moo`0300moogoo01moo`0300moogoo01moo`0300moogoo01moo`0300moogoo01Ioo`03001o
ogoo00Eoo`0027oo0P006goo0P00a@0?0P001goo0007Ool01000Oomoo`006Woo00<007ooOol097oo
00<03gooOol07goo00<03gooOol07goo00<03gooOol07goo00<03gooOol07goo00<03gooOol05Woo
00<007ooOol01Goo0007Ool01000Oomoo`006Woo00<007ooOol097oo00<03gooOol07goo00<03goo
Ool07goo00<03gooOol07goo00<03gooOol07goo00<03gooOol05Woo00<007ooOol01Goo0008Ool3
000JOol00`00Oomoo`0TOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomo
o`0OOol00`0?Oomoo`0FOol00`00Oomoo`05Ool002Eoo`03001oogoo02Aoo`0300moogoo01moo`03
00moogoo01moo`0300moogoo01moo`0300moogoo01moo`0300moogoo01Ioo`03001oogoo00Eoo`00
1goo0`006goo0P00a@0?0P001goo0007Ool00`00Oomoo`0KOol00`00Oomoo`0TOol00`0?Oomoo`0O
Ool00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0FOol00`00Oomoo`05
Ool000Moo`03001oogoo01]oo`03001oogoo02Aoo`0300moogoo01moo`0300moogoo01moo`0300mo
ogoo01moo`0300moogoo01moo`0300moogoo01Ioo`03001oogoo00Eoo`001Woo10006goo00<007oo
Ool097oo00<03gooOol07goo00<03gooOol07goo00<03gooOol07Woo0P008Goo00<03gooOol05Woo
00<007ooOol01Goo0007Ool30007Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`030004
Ool00`00Oomoo`0TOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0MOol4000POol00`0?
Oomoo`0FOol00`00Oomoo`05Ool000Moo`04001oogoo0005Ool00`00Ool00007Ool00`00Ool00003
Ool00`00Oomoo`02Ool2002900l4000h00l20007Ool000Moo`04001oogoo0005Ool00`00Ool00007
Ool01000Ool007oo0`0017oo00<007ooOol097oo00<03gooOol07goo00<03gooOol07goo00<03goo
Ool07Woo0P008Goo00<03gooOol05Woo00<007ooOol01Goo0008Ool20006Ool00`00Ool00007Ool0
1@00Ool007oo00001Woo00<007ooOol097oo00<03gooOol07goo00<03gooOol07goo00<03gooOol0
7goo00<03gooOol07goo00<03gooOol05Woo00<007ooOol01Goo000AOol00`00Oomoo`07Ool00`00
Oomoo`030004Ool00`00Oomoo`0TOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol0
0`0?Oomoo`0OOol00`0?Oomoo`0FOol00`00Oomoo`05Ool000Ioo`@001]oo`800:H03`8001d03`80
00Moo`001goo00<007ooOol06goo00<007ooOol097oo00<03gooOol07goo00<03gooOol07goo00<0
3gooOol07goo00<03gooOol05goo100017oo00<03gooOol05Woo00<007ooOol01Goo0007Ool00`00
Oomoo`0KOol00`00Oomoo`0TOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?
Oomoo`0GOol40004Ool00`0?Oomoo`0FOol00`00Oomoo`05Ool000Ioo`@001]oo`800:H03`8001d0
3`8000Moo`009Goo00<007ooOol097oo00<03gooOol07goo00<03gooOol07goo00<03gooOol07goo
00<03gooOol07goo00<03gooOol05Woo00<007ooOol01Goo0007Ool3000KOol2003500l20007Ool0
00Qoo`8001]oo`03001oogoo02Aoo`0300moogoo01moo`0300moogoo01moo`0300moogoo01moo`03
00moogoo01moo`0300moogoo01Ioo`03001oogoo00Eoo`001goo00<007ooOol06goo00<007ooOol0
97oo00<03gooOol07goo00<03gooOol07goo00<03gooOol07goo00<03gooOol07goo00<03gooOol0
5Woo00<007ooOol01Goo0007Ool3000KOol2003500l20007Ool001Ioo`03001oogoo009oo`04001o
ogooOol30003Ool00`00Oomoo`0TOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol0
0`0?Oomoo`0OOol00`0?Oomoo`0FOol00`00Oomoo`05Ool001Eoo`03001oo`0000Qoo`03001oogoo
009oo`800<D03`8000Moo`005Goo00<007oo000027oo00<007ooOol00Woo00<007ooOol097oo00<0
3gooOol07goo00<03gooOol07goo00<03gooOol07goo00<03gooOol07goo00<03gooOol05Woo00<0
07ooOol01Goo000EOol00`00Ool00008Ool00`00Oomoo`02Ool00`00Oomoo`0TOol00`0?Oomoo`0O
Ool00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0FOol00`00Oomoo`05
Ool001Ioo`03001oogoo00Ioo`8000Aoo`03001oogoo02Aoo`0300moogoo01moo`0300moogoo01mo
o`0300moogoo01moo`0300moogoo01moo`0300moogoo01Ioo`03001oogoo00Eoo`009Goo00<007oo
Ool097oo00<03gooOol07goo00<03gooOol07goo00<03gooOol07goo00<03gooOol07goo00<03goo
Ool05Woo00<007ooOol01Goo0008Ool2000KOol00`00Oomoo`0TOol00`0?Oomoo`0OOol00`0?Oomo
o`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0FOol00`00Oomoo`05Ool000Moo`04
001oogoo000JOol00`00Oomoo`0TOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol0
0`0?Oomoo`0OOol00`0?Oomoo`0FOol00`00Oomoo`05Ool000Moo`04001oogoo000JOol00`00Oomo
o`0TOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomo
o`0FOol00`00Oomoo`05Ool000Qoo`8001]oo`03001oogoo02Aoo`0300moogoo01moo`0300moogoo
01moo`0300moogoo01moo`0300moogoo01moo`0300moogoo01Ioo`03001oogoo00Eoo`001goo1000
6Woo00<007ooOol097oo00<03gooOol07goo00<03gooOol07goo00<03gooOol07goo00<03gooOol0
7goo00<03gooOol05Woo00<007ooOol01Goo0008Ool00`00Oomoo`0JOol00`00Oomoo`0TOol00`0?
Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0FOol00`00
Oomoo`05Ool000Qoo`03001oogoo01Yoo`03001oogoo02Aoo`0300moogoo01moo`0300moogoo01mo
o`0300moogoo01moo`0300moogoo01moo`0300moogoo01Ioo`03001oogoo00Eoo`001goo10006Woo
00<007ooOol097oo00<03gooOol07goo00<03gooOol07goo00<03gooOol07goo00<03gooOol07goo
00<03gooOol05Woo00<007ooOol01Goo0008Ool00`00Oomoo`0JOol00`00Oomoo`0TOol00`0?Oomo
o`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0FOol00`00Oomo
o`05Ool000Qoo`<001Yoo`800<D03`8000Moo`009Goo00<007ooOol097oo00<03gooOol07goo00<0
3gooOol07goo00<03gooOol07goo00<03gooOol07goo00<03gooOol05Woo00<007ooOol01Goo000U
Ool00`00Oomoo`0TOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0O
Ool00`0?Oomoo`0FOol00`00Oomoo`05Ool002Eoo`03001oogoo02Aoo`0300moogoo01moo`0300mo
ogoo01moo`0300moogoo01moo`0300moogoo01moo`0300moogoo01Ioo`03001oogoo00Eoo`009Goo
00<007ooOol097oo00<03gooOol07goo00<03gooOol07goo00<03gooOol07goo00<03gooOol07goo
00<03gooOol05Woo00<007ooOol01Goo0007Ool00`00Ool0000KOol00`00Oomoo`0TOol00`0?Oomo
o`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0FOol00`00Oomo
o`05Ool000Moo`03001oo`0001]oo`03001oogoo02Aoo`0300moogoo01moo`0300moogoo01moo`03
00moogoo01moo`0300moogoo01moo`0300moogoo015oo`8000=oo`03001oogoo00Eoo`001goo00<0
07oo00006goo00<007ooOol097oo00<03gooOol07goo00<03gooOol07goo00<03gooOol07goo00<0
3gooOol07goo00<03gooOol047oo10000Woo00<007ooOol01Goo0006Ool4000KOol2003000l40000
0`0?00000007Ool002Eoo`03001oogoo009oo`03001oogoo01moo`03001oogoo01moo`03001oogoo
01moo`03001oogoo01moo`03001oogoo01moo`03001oogoo015oo`8000=oo`03001oogoo00Eoo`00
9Goob@001goo0000\
\>"],
  ImageRangeCache->{{{0, 244}, {150, 0}} -> {13.7882, -3.70814, 0.146968, 
  0.0216063}}],

Cell["\<\
Figure showing how the computational time needed to factor an \
integer grows with the \"size\" of the integer. An explanation is given in \
this Notebook.\
\>", "Text",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["Copyright Notice", "Section",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
Copyright Colin P. Williams (1997).

This Notebook is intended to be used in conjunction with \"Explorations in \
Quantum Computing\" by Colin P. Williams and Scott H. Clearwater, TELOS, \
Springer-Verlag (1997), ISBN:0-387-94768-X. Permission is hereby granted to \
copy and distribute this Notebook freely for any non-commercial activity \
provided you include this copyright notice at the beginning of all such \
copies. Please send suggestions and bug reports to Colin P. Williams at 
        colin@solstice.jpl.nasa.gov      (818) 306 6512 or 
        cpw@cs.stanford.edu               (415) 728 2118
For information on \"Explorations in Quantum Computing\" check out the TELOS \
web site:  http://www.telospub.com/catalog/PHYSICS/Explorations.html. To \
order call 1-800-777-4643.

All other rights reserved.\
\>", "Text",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["The FactorInteger Command", "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
To break a message encrypted using RSA public-key cryptography, it \
is necessary to determine the factors of a large integer.  We can use the \
built-in function FactorInteger to explore how the cost of factoring scales \
up with the number of bits needed to describe the integer beingfactored. The \
number of bits in the integer is usually taken to be a measure of the \
\"size\" of the integer.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["The FactorInteger command works as follows:", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["?FactorInteger", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \("FactorInteger[n] gives a list of the prime factors of the integer n, \
together with their exponents."\)], "Print"]
}, Open  ]],

Cell["So to factor the integer 566082458573800 you would enter:", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["Try me!", "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["FactorInteger[566082458573800]", "Input",
  AspectRatioFixed->True],

Cell[OutputFormData["\<\
{{2, 3}, {5, 2}, {7, 4}, {17, 1}, {37, 5}}\
\>", 
"\<\
{{2, 3}, {5, 2}, {7, 4}, {17, 1}, {37, 5}}\
\>"], "Output",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Open  ]],

Cell[TextData[{
  StyleBox["This is ",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  "'s representation of the factorization. A more readable factorization is \
given by reformatting this output using our FactorIntegerProduct command:",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Definition of FactorIntegerProduct hidden here ...", "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
FactorIntegerProduct[x_]:=
\tApply[Times, 
\t      Map[#[[1]]^ToString[#[[2]]]&, FactorInteger[x]]]\
\>", "Input",
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Try me!", "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["FactorIntegerProduct[566082458573800]", "Input",
  AspectRatioFixed->True],

Cell[OutputFormData["\<\
2^\"3\"*5^\"2\"*7^\"4\"*17^\"1\"*37^\"5\"\
\>", 
"\<\
 3  2  4   1   5
2  5  7  17  37\
\>"], "Output",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Open  ]],

Cell["This looks much better to the eye.", "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Timing FactorInteger", "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["To determine how long it takes ",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" to factor an integer, use the TimeToFactorInteger command:",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
TimeToFactorInteger[n_]:=
\tTiming[FactorInteger[n]][[1]]\
\>", "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["Try me!", "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["TimeToFactorInteger[1234567891234567891234567879]", "Input",
  AspectRatioFixed->True],

Cell[OutputFormData["\<\
0.25*Second\
\>", "\<\
0.25 Second\
\>"], "Output",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["The \"Size\" of an Integer", "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
The size of an integer is given by the number of bits needed to \
define the integer. This can be determined using SizeOfInteger:\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
SizeOfInteger[n_]:=
\tLength[IntegerDigits[n,2]] Bits\
\>", "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["Try me!", "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["SizeOfInteger[12345]", "Input",
  AspectRatioFixed->True],

Cell[OutputFormData["\<\
14*Bits\
\>", "\<\
14 Bits\
\>"], "Output",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["A Random Integer of a Certain Size", "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
RandomNBitInteger[n_]:=
\tRandom[Integer, {2^(n-1), 2^n - 1}]\
\>", "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["Try me!", "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["RandomNBitInteger[20]", "Input",
  AspectRatioFixed->True],

Cell[OutputFormData["\<\
567280\
\>", "\<\
567280\
\>"], "Output",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Try me!", "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Let's test our function on n=40 bits.", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
Needs[\"Statistics`DescriptiveStatistics`\"];

AverageTimeToFactorNBitInteger[n_, samples_:1000]:=
    {n, Mean[Table[TimeToFactorInteger[RandomNBitInteger[n]][[1]], \
{samples}]]}\
\>", "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["AverageTimeToFactorNBitInteger[40]", "Input",
  AspectRatioFixed->True],

Cell[OutputFormData["\<\
{40, 0.04749999999999091}\
\>", 
"\<\
{40, 0.0475}\
\>"], "Output",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Open  ]],

Cell["\<\
Looks, ok, so let's try for the full plot of the average time to \
factor an n-
bit number for n=20 to n=60 bits in steps of 4 bits.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Try me!", "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
The first plot generated is a sub-exponential fit to the data. The \
second plot is an exponential fit and the last plot is a log plot of the \
timing data.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["PlotTimeToFactorInteger[20, 50, 4, 10000]", "Input",
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
%% Graphics
/Courier findfont 8  scalefont  setfont
% Scaling calculations
-0.656463 0.0340136 0.0147151 2.55915 [
[(20)] .02381 0 0 2 0 Minner Mrotsboxa
[(25)] .19388 0 0 2 0 Minner Mrotsboxa
[(30)] .36395 0 0 2 0 Minner Mrotsboxa
[(35)] .53401 0 0 2 0 Minner Mrotsboxa
[(40)] .70408 0 0 2 0 Minner Mrotsboxa
[(45)] .87415 0 0 2 0 Minner Mrotsboxa
[(Size of n \\(bits\\))] .5 0 0 2 0 0 -1 Mouter Mrotsboxa
[(0)] -0.0125 .01472 1 0 0 Minner Mrotsboxa
[(0.05)] -0.0125 .14267 1 0 0 Minner Mrotsboxa
[(0.1)] -0.0125 .27063 1 0 0 Minner Mrotsboxa
[(0.15)] -0.0125 .39859 1 0 0 Minner Mrotsboxa
[(0.2)] -0.0125 .52654 1 0 0 Minner Mrotsboxa
[(Time \\(seconds\\))] -0.0125 .30902 1 0 90 -1 0 Mouter Mrotsboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 .61903 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
0 0 .5 r
.001 w
.19388 0 m
.19388 .61803 L
s
P
p
0 0 .5 r
.001 w
.36395 0 m
.36395 .61803 L
s
P
p
0 0 .5 r
.001 w
.53401 0 m
.53401 .61803 L
s
P
p
0 0 .5 r
.001 w
.70408 0 m
.70408 .61803 L
s
P
p
0 0 .5 r
.001 w
.87415 0 m
.87415 .61803 L
s
P
p
0 0 .5 r
.001 w
0 .14267 m
1 .14267 L
s
P
p
0 0 .5 r
.001 w
0 .27063 m
1 .27063 L
s
P
p
0 0 .5 r
.001 w
0 .39859 m
1 .39859 L
s
P
p
0 0 .5 r
.001 w
0 .52654 m
1 .52654 L
s
P
p
.002 w
.02381 0 m
.02381 .00625 L
s
P
[(20)] .02381 0 0 2 0 Minner Mrotshowa
p
.002 w
.19388 0 m
.19388 .00625 L
s
P
[(25)] .19388 0 0 2 0 Minner Mrotshowa
p
.002 w
.36395 0 m
.36395 .00625 L
s
P
[(30)] .36395 0 0 2 0 Minner Mrotshowa
p
.002 w
.53401 0 m
.53401 .00625 L
s
P
[(35)] .53401 0 0 2 0 Minner Mrotshowa
p
.002 w
.70408 0 m
.70408 .00625 L
s
P
[(40)] .70408 0 0 2 0 Minner Mrotshowa
p
.002 w
.87415 0 m
.87415 .00625 L
s
P
[(45)] .87415 0 0 2 0 Minner Mrotshowa
p
.001 w
.05782 0 m
.05782 .00375 L
s
P
p
.001 w
.09184 0 m
.09184 .00375 L
s
P
p
.001 w
.12585 0 m
.12585 .00375 L
s
P
p
.001 w
.15986 0 m
.15986 .00375 L
s
P
p
.001 w
.22789 0 m
.22789 .00375 L
s
P
p
.001 w
.2619 0 m
.2619 .00375 L
s
P
p
.001 w
.29592 0 m
.29592 .00375 L
s
P
p
.001 w
.32993 0 m
.32993 .00375 L
s
P
p
.001 w
.39796 0 m
.39796 .00375 L
s
P
p
.001 w
.43197 0 m
.43197 .00375 L
s
P
p
.001 w
.46599 0 m
.46599 .00375 L
s
P
p
.001 w
.5 0 m
.5 .00375 L
s
P
p
.001 w
.56803 0 m
.56803 .00375 L
s
P
p
.001 w
.60204 0 m
.60204 .00375 L
s
P
p
.001 w
.63605 0 m
.63605 .00375 L
s
P
p
.001 w
.67007 0 m
.67007 .00375 L
s
P
p
.001 w
.7381 0 m
.7381 .00375 L
s
P
p
.001 w
.77211 0 m
.77211 .00375 L
s
P
p
.001 w
.80612 0 m
.80612 .00375 L
s
P
p
.001 w
.84014 0 m
.84014 .00375 L
s
P
p
.001 w
.90816 0 m
.90816 .00375 L
s
P
p
.001 w
.94218 0 m
.94218 .00375 L
s
P
p
.001 w
.97619 0 m
.97619 .00375 L
s
P
[(Size of n \\(bits\\))] .5 0 0 2 0 0 -1 Mouter Mrotshowa
p
.002 w
0 0 m
1 0 L
s
P
p
.002 w
0 .01472 m
.00625 .01472 L
s
P
[(0)] -0.0125 .01472 1 0 0 Minner Mrotshowa
p
.002 w
0 .14267 m
.00625 .14267 L
s
P
[(0.05)] -0.0125 .14267 1 0 0 Minner Mrotshowa
p
.002 w
0 .27063 m
.00625 .27063 L
s
P
[(0.1)] -0.0125 .27063 1 0 0 Minner Mrotshowa
p
.002 w
0 .39859 m
.00625 .39859 L
s
P
[(0.15)] -0.0125 .39859 1 0 0 Minner Mrotshowa
p
.002 w
0 .52654 m
.00625 .52654 L
s
P
[(0.2)] -0.0125 .52654 1 0 0 Minner Mrotshowa
p
.001 w
0 .04031 m
.00375 .04031 L
s
P
p
.001 w
0 .0659 m
.00375 .0659 L
s
P
p
.001 w
0 .09149 m
.00375 .09149 L
s
P
p
.001 w
0 .11708 m
.00375 .11708 L
s
P
p
.001 w
0 .16826 m
.00375 .16826 L
s
P
p
.001 w
0 .19386 m
.00375 .19386 L
s
P
p
.001 w
0 .21945 m
.00375 .21945 L
s
P
p
.001 w
0 .24504 m
.00375 .24504 L
s
P
p
.001 w
0 .29622 m
.00375 .29622 L
s
P
p
.001 w
0 .32181 m
.00375 .32181 L
s
P
p
.001 w
0 .3474 m
.00375 .3474 L
s
P
p
.001 w
0 .373 m
.00375 .373 L
s
P
p
.001 w
0 .42418 m
.00375 .42418 L
s
P
p
.001 w
0 .44977 m
.00375 .44977 L
s
P
p
.001 w
0 .47536 m
.00375 .47536 L
s
P
p
.001 w
0 .50095 m
.00375 .50095 L
s
P
p
.001 w
0 .55214 m
.00375 .55214 L
s
P
p
.001 w
0 .57773 m
.00375 .57773 L
s
P
p
.001 w
0 .60332 m
.00375 .60332 L
s
P
[(Time \\(seconds\\))] -0.0125 .30902 1 0 90 -1 0 Mouter Mrotshowa
p
.002 w
0 0 m
0 .61803 L
s
P
P
p
p
.002 w
.02381 .61178 m
.02381 .61803 L
s
P
p
.002 w
.19388 .61178 m
.19388 .61803 L
s
P
p
.002 w
.36395 .61178 m
.36395 .61803 L
s
P
p
.002 w
.53401 .61178 m
.53401 .61803 L
s
P
p
.002 w
.70408 .61178 m
.70408 .61803 L
s
P
p
.002 w
.87415 .61178 m
.87415 .61803 L
s
P
p
.001 w
.05782 .61428 m
.05782 .61803 L
s
P
p
.001 w
.09184 .61428 m
.09184 .61803 L
s
P
p
.001 w
.12585 .61428 m
.12585 .61803 L
s
P
p
.001 w
.15986 .61428 m
.15986 .61803 L
s
P
p
.001 w
.22789 .61428 m
.22789 .61803 L
s
P
p
.001 w
.2619 .61428 m
.2619 .61803 L
s
P
p
.001 w
.29592 .61428 m
.29592 .61803 L
s
P
p
.001 w
.32993 .61428 m
.32993 .61803 L
s
P
p
.001 w
.39796 .61428 m
.39796 .61803 L
s
P
p
.001 w
.43197 .61428 m
.43197 .61803 L
s
P
p
.001 w
.46599 .61428 m
.46599 .61803 L
s
P
p
.001 w
.5 .61428 m
.5 .61803 L
s
P
p
.001 w
.56803 .61428 m
.56803 .61803 L
s
P
p
.001 w
.60204 .61428 m
.60204 .61803 L
s
P
p
.001 w
.63605 .61428 m
.63605 .61803 L
s
P
p
.001 w
.67007 .61428 m
.67007 .61803 L
s
P
p
.001 w
.7381 .61428 m
.7381 .61803 L
s
P
p
.001 w
.77211 .61428 m
.77211 .61803 L
s
P
p
.001 w
.80612 .61428 m
.80612 .61803 L
s
P
p
.001 w
.84014 .61428 m
.84014 .61803 L
s
P
p
.001 w
.90816 .61428 m
.90816 .61803 L
s
P
p
.001 w
.94218 .61428 m
.94218 .61803 L
s
P
p
.001 w
.97619 .61428 m
.97619 .61803 L
s
P
p
.002 w
0 .61803 m
1 .61803 L
s
P
p
.002 w
.99375 .01472 m
1 .01472 L
s
P
p
.002 w
.99375 .14267 m
1 .14267 L
s
P
p
.002 w
.99375 .27063 m
1 .27063 L
s
P
p
.002 w
.99375 .39859 m
1 .39859 L
s
P
p
.002 w
.99375 .52654 m
1 .52654 L
s
P
p
.001 w
.99625 .04031 m
1 .04031 L
s
P
p
.001 w
.99625 .0659 m
1 .0659 L
s
P
p
.001 w
.99625 .09149 m
1 .09149 L
s
P
p
.001 w
.99625 .11708 m
1 .11708 L
s
P
p
.001 w
.99625 .16826 m
1 .16826 L
s
P
p
.001 w
.99625 .19386 m
1 .19386 L
s
P
p
.001 w
.99625 .21945 m
1 .21945 L
s
P
p
.001 w
.99625 .24504 m
1 .24504 L
s
P
p
.001 w
.99625 .29622 m
1 .29622 L
s
P
p
.001 w
.99625 .32181 m
1 .32181 L
s
P
p
.001 w
.99625 .3474 m
1 .3474 L
s
P
p
.001 w
.99625 .373 m
1 .373 L
s
P
p
.001 w
.99625 .42418 m
1 .42418 L
s
P
p
.001 w
.99625 .44977 m
1 .44977 L
s
P
p
.001 w
.99625 .47536 m
1 .47536 L
s
P
p
.001 w
.99625 .50095 m
1 .50095 L
s
P
p
.001 w
.99625 .55214 m
1 .55214 L
s
P
p
.001 w
.99625 .57773 m
1 .57773 L
s
P
p
.001 w
.99625 .60332 m
1 .60332 L
s
P
p
.002 w
1 0 m
1 .61803 L
s
P
P
p
P
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
p
p
[ .02 .02 ] 0 setdash
.7 g
p
2 Mabswid
.02381 .01619 m
.06349 .01674 L
.10317 .01748 L
.14286 .01846 L
.18254 .01973 L
.22222 .02139 L
.2619 .02352 L
.30159 .02627 L
.34127 .02976 L
.38095 .0342 L
.42063 .03981 L
.46032 .04685 L
.5 .05567 L
.53968 .06665 L
.57937 .08029 L
.61905 .09715 L
.65873 .11792 L
.69841 .14342 L
.7381 .17462 L
.77778 .21268 L
.81746 .25896 L
.85714 .31508 L
.89683 .38295 L
.93651 .46479 L
.97619 .56323 L
s
P
P
p
p
.02 w
.02381 .018 Mdot
.15986 .01787 Mdot
.29592 .01949 Mdot
.43197 .03476 Mdot
.56803 .08855 Mdot
.70408 .19113 Mdot
.84014 .31708 Mdot
.97619 .60332 Mdot
P
P
P
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{245, 151},
  ImageMargins->{{34, Inherited}, {Inherited, Inherited}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003e0000Ua000`40O003h00OmGoo003eOol00?Eo
o`00Tgoo00<007ooOol057oo00<007ooOol0B7oo001QOol9000017oo000000000Woo0`001goo0P00
0Woo10001Goo00<007oo000027oo00@007ooOomoo`<00003Ool0000000H0009oo`<000Aoo`03001o
ogoo04Moo`00HGoo00@007ooOol0009oo`04001oogooOol20002Ool00`00Oomoo`07Ool01000Oomo
o`000Woo00<007ooOol01Goo00<007oo000027oo00D007ooOomoo`00009oo`04001oogoo0002Ool0
0`00Oomoo`03Ool20004Ool00`00Oomoo`17Ool0069oo`8000=oo`03001oogoo009oo`800003Ool0
0000008000Ioo`04001oogoo0002Ool00`00Oomoo`05Ool00`00Ool00008Ool01@00Oomoogoo0000
0Woo00@007ooOol0009oo`03001oogoo009oo`03001oogoo00Aoo`03001oogoo04Moo`00HGoo00D0
07ooOol007oo008000=oo`<0009oo`8000Qoo`80009oo`@000Aoo`@000Qoo`04001oogooOol30002
Ool200000goo000000020002Ool30004Ool00`00Oomoo`17Ool0065oo`@001Yoo`03001oogoo015o
o`04001oogoo0008Ool00`00Oomoo`08Ool00`00Oomoo`18Ool006Moo`03001oogoo01Eoo`<001=o
o`8000Eoo`03001oogoo05Ioo`00mGoo003eOol00?Eoo`00mGoo003eOol00?Eoo`00mGoo003eOol0
02Aoo`<000=oo`03001oogoo01Uoo`<0009oo`<001Yoo`<000=oo`03001oogoo01Uoo`<0009oo`<0
01aoo`05001oogooOol0000MOol00`00Oomoo`03000OOol002Eoo`07001oogooOol007oo00006goo
00<007ooOol00goo00<007ooOol06Woo00H007ooOol007oo000LOol00`00Oomoo`02Ool00`00Oomo
o`0HOol30002Ool00`00Ool0000JOol30004Ool00`00Oomoo`0MOol002Ioo`06001oogoo001oo`00
77oo00<007ooOol00`006goo00L007ooOomoo`00Ool0000KOol01000Oomoogoo0`006Woo00<007oo
00000Woo00<007oo00006Woo00<007oo00000Woo0`007goo000VOol01P00Oomoo`00Ool001aoo`04
001oogoo000NOol01P00Oomoo`00Ool001aoo`04001oogoo000MOol20002Ool00`00Ool0000KOol2
0002Ool00`00Oomoo`0OOol002Aoo`<000=oo`03001oogoo01Uoo`<0009oo`<001Yoo`<000=oo`03
001oogoo01Uoo`<0009oo`<001aoo`05001oogooOol0000MOol00`00Oomoo`03000OOol00?Eoo`00
mGoo003eOol00?Eoo`008goob@002Goo000SOol01@00Oomoogoo00008Goo00<007ooOol07goo00<0
07ooOol07goo00<007ooOol07goo00<007ooOol07goo00<007ooOol05goo00<007ooOol01goo000M
Ool00`00Oomoo`03Ool01000Oomoogoo0P006Goo0P001Goo00<03gooOol04Goo0P0037oo00<03goo
Ool07goo00<03gooOol07goo00<03gooOol07goo00<03gooOol05goo00<007ooOol01goo000LOol0
0`00Ool00004Ool200000goo000000020002F]H2Ool6F]H2Ool6F]H2Ool3F]H40004Ool00`0?Oomo
o`0@Ool4000;Ool00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0EOol3
0009Ool001aoo`03001oo`0000Aoo`03001oogoo00@0009JeP9oo`IJeP9oo`IJeP9oo`=JeP@00003
OomJeU[F00AJeP9oo`IJeP9oo`AJeP9oo`@000]oo`0300moogoo01moo`0300moogoo01moo`0300mo
ogoo01moo`0300moogoo01Moo`03001oogoo00Moo`0077oo00<007oo000017oo00@007ooOomoo`80
01Qoo`03F]H00000009oo`IJeP9oo`IJeP9oo`IJeP03Ool0000000EJePMoo`0300moogoo00]oo`80
019oo`0300moogoo01moo`0300moogoo01moo`0300moogoo01Moo`03001oogoo00Moo`007Goo00<0
07ooOol00goo00<007ooOol08goo00<03gooOol03Goo0e[F0Woo1U[F0Woo1U[F37oo10004Goo00<0
3gooOol07goo00<03gooOol07goo00<03gooOol05goo00<007ooOol01goo000SOol00`00Oomoo`0S
Ool00`0?Oomoo`0JOol6F]H2Ool6F]H4Ool4000AOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?
Oomoo`0GOol00`00Oomoo`07Ool002=oo`03001oogoo02=oo`0300moogoo01moo`0300moogoo00IJ
eP9oo`=JeP800003F]Ioogoo00moo`0300moogoo01moo`0300moogoo01moo`0300moogoo01Ioo`80
00Uoo`008goo00<007ooOol08goo00<03gooOol07goo00<03gooOol027oo1U[F0Woo15[F2goo00<0
3gooOol07goo00<03gooOol07goo00<03gooOol05goo00<007ooOol01goo000SOol00`00Oomoo`0S
Ool00`0?Oomoo`0OOol00`0?Oomoo`0@Ool6F]H9Ool00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?
Oomoo`0GOol00`00Oomoo`07Ool002=oo`03001oogoo02=oo`0300moogoo01moo`0300moogoo01=o
o`=JeP9oo`AJeP=oo`0300moogoo01moo`0300moogoo01moo`0300moogoo01Moo`03001oogoo00Mo
o`008goo00<007ooOol08goo00<03gooOol07goo00<03gooOol067oo1U[F00=oo`0?Ool087oo00<0
3gooOol07goo00<03gooOol05goo00<007ooOol01goo000SOol00`00Oomoo`0SOol00`0?Oomoo`0O
Ool00`0?Oomoo`0KOol3F]H00goo00mJeP03F]HMOol00`0?Oomoo`0OOol00`0?Oomoo`0FOol20009
Ool002=oo`03001oogoo02=oo`0300moogoo01moo`0300moogoo01moo`0300mJeU[F00=JeQaoo`03
00moogoo01moo`0300moogoo01Moo`03001oogoo00Moo`008goo00<007ooOol08goo00<03gooOol0
7goo00<03gooOol07goo00@03gooOomoo`9JeQaoo`0300moogoo01moo`0300moogoo01Moo`03001o
ogoo00Moo`008goo00<007ooOol08goo00<03gooOol07goo00<03gooOol07goo00<03gooOol017oo
0P000e[F5Woo00<03gooOol07goo00<03gooOol05goo00<007ooOol01goo000SOol00`00Oomoo`0S
Ool00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`03Ool40004F]HDOol00`0?Oomoo`0OOol0
0`0?Oomoo`0GOol00`00Oomoo`07Ool002=oo`03001oogoo02=oo`0300moogoo01moo`0300moogoo
01moo`0300moogoo00=oo`@00004OomJeU[FF]HDOol00`0?Oomoo`0OOol00`0?Oomoo`0FOol20009
Ool002=oo`03001oogoo02=oo`0300moogoo01moo`0300moogoo01moo`0300moogoo00Aoo`8000Io
o`AJePmoo`0300moogoo01moo`0300moogoo01Moo`03001oogoo00Moo`008goo00<007ooOol08goo
00<03gooOol07goo00<03gooOol07goo00<03gooOol037oo1E[F3Woo00<03gooOol07goo00<03goo
Ool05goo00<007ooOol01goo000SOol00`00Oomoo`0SOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol0
0`0?Oomoo`0?Ool3F]H=Ool00`0?Oomoo`0OOol00`0?Oomoo`0GOol00`00Oomoo`07Ool002=oo`03
001oogoo02=oo`0300moogoo01moo`0300moogoo01moo`0300moogoo011oo`9JeP9oo`9JePUoo`03
00moogoo01moo`0300moogoo01Moo`03001oogoo00Moo`008goo00<007ooOol08goo00<03gooOol0
7goo00<03gooOol07goo00<03gooOol057oo15[F1goo00<03gooOol07goo00<03gooOol05Woo0P00
2Goo000SOol00`00Oomoo`0SOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0EOol4F]H6
Ool00`0?Oomoo`0OOol00`0?Oomoo`0GOol00`00Oomoo`07Ool002=oo`03001oogoo02=oo`0300mo
ogoo01moo`0300moogoo01moo`0300moogoo01Moo`9JePIoo`0300moogoo01moo`0300moogoo01Mo
o`03001oogoo00Moo`008goo00<007ooOol08goo00<03gooOol07goo00<03gooOol07goo00<03goo
Ool07goo00<03gooOol07goo00<03gooOol05goo00<007ooOol01goo000?Ool00`00Oomoo`02Ool0
0`00Oomoo`02Ool00`00Oomoo`030004Ool00`00Oomoo`0SOol00`0?Oomoo`0OOol00`0?Oomoo`0O
Ool00`0?Oomoo`0JOol4F]H00goo00moo`0POol00`0?Oomoo`0GOol00`00Oomoo`07Ool000ioo`03
001oo`0000Moo`03001oo`0000=oo`03001oogoo009oo`8008D03`EJeSX03`<000Uoo`002Goo0`00
0Woo00<007oo00001goo00@007oo001oo`<000Aoo`03001oogoo02=oo`0300moogoo01moo`0300mo
ogoo01moo`0300moogoo01eoo`=JeR5oo`0300moogoo01Moo`03001oogoo00Moo`002Woo00L007oo
Oomoo`00Ool00007Ool01@00Ool007oo00001Woo00<007ooOol08goo00<03gooOol07goo00<03goo
Ool07goo00<03gooOol07Woo0U[F8Goo00<03gooOol05goo00<007ooOol01goo000:Ool00`00Oomo
o`02Ool00`00Oomoo`07Ool00`00Oomoo`030004Ool00`00Oomoo`0SOol00`0?Oomoo`0OOol00`0?
Oomoo`0OOol00`0?Oomoo`0OOol0100?OomJeU[F7Woo00<03gooOol05goo00<007ooOol01goo0008
Ool01@00Ool007oo00005Woo00<007ooOol08goo00<03gooOol07goo00<03gooOol07goo00<03goo
Ool07goo00<03gooF]H00U[F7Goo00<03gooOol05goo00<007ooOol01goo0008Ool5000FOol00`00
Oomoo`0SOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`03F]HLOol0
0`0?Oomoo`0FOol20009Ool000Qoo`D001Ioo`03001oogoo02=oo`0300moogoo01moo`0300moogoo
01moo`0300moogoo01moo`0400moogooOol3F]HKOol00`0?Oomoo`0GOol00`00Oomoo`07Ool000Yo
o`03001oogoo01Ioo`03001oogoo02=oo`0300moogoo01moo`0300moogoo01moo`0300moogoo01mo
o`0300moogoo009oo`9JeQ]oo`0300moogoo01Moo`03001oogoo00Moo`002Woo00<007ooOol05Woo
00<007ooOol08goo00<03gooOol07goo00<03gooOol07goo00<03gooOol07goo0P001Woo0U[F67oo
00<03gooOol05goo00<007ooOol01goo0009Ool2000HOol00`00Oomoo`0SOol00`0?Oomoo`0OOol0
0`0?Oomoo`0OOol00`0?Oomoo`0NOol40005Ool3F]HGOol00`0?Oomoo`0GOol00`00Oomoo`07Ool0
02=oo`03001oogoo02=oo`0300moogoo01moo`0300moogoo01moo`0300moogoo01ioo`@000Ioo`=J
eQIoo`0300moogoo01Ioo`8000Uoo`0027oo00D007oo001oo`0001Ioo`03001oogoo02=oo`0300mo
ogoo01moo`0300moogoo01moo`0300moogoo01moo`8000Qoo`=JeQEoo`0300moogoo01Moo`03001o
ogoo00Moo`0027oo00D007oo001oo`0001Ioo`03001oogoo02=oo`0300moogoo01moo`0300moogoo
01moo`0300moogoo01moo`0300moogoo00Qoo`9JeQEoo`0300moogoo01Moo`03001oogoo00Moo`00
27oo00D007oo001oo`0001Ioo`03001oogoo02=oo`0300moogoo01moo`0300moogoo01moo`0300mo
ogoo01moo`0300moogoo01moo`0300moogoo01Moo`03001oogoo00Moo`0027oo1@005Woo00<007oo
Ool08goo00<03gooOol07goo00<03gooOol07goo00<03gooOol07goo00<03gooOol02goo0U[F4Woo
00<03gooOol05goo00<007ooOol01goo000SOol00`00Oomoo`0SOol00`0?Oomoo`0OOol00`0?Oomo
o`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0;Ool2F]HBOol00`0?Oomoo`0GOol00`00Oomoo`07Ool0
00Yoo`<001Ioo`03001oogoo02=oo`0300moogoo01moo`0300moogoo01moo`0300moogoo01moo`03
00moogoo00]oo`=JeQ5oo`0300moogoo01Ioo`8000Uoo`002Goo00<007ooOol05goo00<007ooOol0
8goo00<03gooOol07goo00<03gooOol07goo00<03gooOol07goo00<03gooOol037oo0e[F47oo00<0
3gooOol05goo00<007ooOol01goo0009Ool4000FOol00`00Oomoo`0SOol00`0?Oomoo`0OOol00`0?
Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0=Ool2F]H@Ool00`0?Oomoo`0GOol00`00Oomoo`07
Ool000Yoo`8001Moo`03001oogoo02=oo`0300moogoo01moo`0300moogoo01moo`0300moogoo01mo
o`0300moogoo01moo`0300moogoo01Moo`03001oogoo00Moo`008goo00<007ooOol08goo00<03goo
Ool07goo00<03gooOol07goo00<03gooOol07goo00<03gooOol047oo0U[F3Goo00<03gooOol05goo
00<007ooOol01goo000SOol00`00Oomoo`0SOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomo
o`0OOol00`0?Oomoo`0@Ool3F]H<Ool00`0?Oomoo`0FOol20009Ool002=oo`03001oogoo02=oo`03
00moogoo01moo`0300moogoo01moo`0300moogoo01moo`0300moogoo015oo`=JeP]oo`0300moogoo
01Moo`03001oogoo00Moo`008goo00<007ooOol08goo00<03gooOol07goo00<03gooOol07goo00<0
3gooOol07goo00<03gooOol04Woo0e[F2Woo00<03gooOol05goo00<007ooOol01goo000;Ool00`00
Oomoo`0EOol00`00Oomoo`0SOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?
Oomoo`0COol2F]H:Ool00`0?Oomoo`0GOol00`00Oomoo`07Ool000Yoo`03001oogoo00Moo`03001o
ogoo009oo`04001oogooOol30003Ool00`00Oomoo`0SOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol0
0`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0GOol00`00Oomoo`07Ool000Yoo`03001oogoo
00Ioo`03001oo`0000Qoo`03001oogoo009oo`800:803`9JeR003`<000Uoo`002Woo00<007ooOol0
1Woo00<007oo000027oo00<007ooOol00Woo00<007ooOol08goo00<03gooOol07goo00<03gooOol0
7goo00<03gooOol07goo00<03gooOol05Goo0U[F27oo00<03gooOol05goo00<007ooOol01goo000:
Ool00`00Oomoo`06Ool00`00Ool00008Ool00`00Oomoo`02Ool00`00Oomoo`0SOol00`0?Oomoo`0O
Ool00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0EOol3F]H7Ool00`0?Oomoo`0GOol00`00
Oomoo`07Ool000]oo`03001oogoo00Ioo`03001oogoo00Ioo`8000Aoo`03001oogoo02=oo`0300mo
ogoo01moo`0300moogoo01moo`0300moogoo01moo`0300moogoo01Ioo`=JePIoo`0300moogoo01Mo
o`03001oogoo00Moo`002Goo0`005goo00<007ooOol08goo00<03gooOol07goo00<03gooOol07goo
00<03gooOol07goo00<03gooOol05goo0U[F1Woo00<03gooOol05goo00<007ooOol01goo000:Ool2
000GOol00`00Oomoo`0SOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomo
o`0OOol00`0?Oomoo`0FOol20009Ool000Uoo`03001oogoo01Moo`03001oogoo02=oo`0300moogoo
01moo`0300moogoo01moo`0300moogoo01moo`0300moogoo01moo`0300moogoo01Moo`03001oogoo
00Moo`002Goo0`005goo00<007ooOol08goo00<03gooOol07goo00<03gooOol07goo00<03gooOol0
7goo00<03gooOol06Woo0U[F0goo00<03gooOol05goo00<007ooOol01goo000SOol00`00Oomoo`0S
Ool00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0HOol20002F]H3Ool0
0`0?Oomoo`0GOol00`00Oomoo`07Ool000Yoo`<001Ioo`03001oogoo02=oo`0300moogoo01moo`03
00moogoo01moo`0300moogoo01moo`0300moogoo01Moo`@0009JeP9oo`0300moogoo01Moo`03001o
ogoo00Moo`002Goo00<007ooOol05goo00<007ooOol08goo00<03gooOol07goo00<03gooOol07goo
00<03gooOol07goo00<03gooOol05goo10000e[F00=oo`0?Ool05goo0P002Goo0009Ool4000FOol0
0`00Oomoo`0SOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0HOol2
0002Ool2F]H00goo00moo`0HOol00`00Oomoo`07Ool000Yoo`8001Moo`03001oogoo02=oo`0300mo
ogoo01moo`0300moogoo01moo`0300moogoo01moo`0300moogoo01moo`0300moogoo01Moo`03001o
ogoo00Moo`008goo00<007ooOol08goo00<03gooOol07goo00<03gooOol07goo00<03gooOol07goo
00<03gooOol07goo00<03gooOol05goo00<007ooOol01goo000:Ool2000GOol00`00Oomoo`0SOol0
0`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0NOol2F]HIOol00`00Oomo
o`07Ool000Uoo`04001oogoo000FOol00`00Oomoo`0SOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol0
0`0?Oomoo`0OOol00`0?Oomoo`0NOol2F]HHOol20009Ool000Uoo`04001oogoo000FOol00`00Oomo
o`0SOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0NOol3F]HHOol0
0`00Oomoo`07Ool000Yoo`<001Ioo`03001oogoo02=oo`0300moogoo01moo`0300moogoo01moo`03
00moogoo01moo`0300moogoo01moo`=JeQMoo`03001oogoo00Moo`002Woo0P005goo00<007ooOol0
8goo00<03gooOol07goo00<03gooOol07goo00<03gooOol07goo00<03gooOol07goo00<03e[FF]H0
5goo00<007ooOol01goo0009Ool01000Oomoo`005Woo00<007ooOol08goo00<03gooOol07goo00<0
3gooOol07goo00<03gooOol07goo00<03gooOol07goo00<03gooOol05goo00<007ooOol01goo0009
Ool01000Oomoo`005Woo00<007ooOol08goo00<03gooOol07goo00<03gooOol07goo00<03gooOol0
7goo00<03gooOol07goo00<03gooOol00U[F57oo0P002Goo000:Ool2000GOol00`00Oomoo`0SOol0
0`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`02F]HE
Ool00`00Oomoo`07Ool002=oo`03001oogoo02=oo`0300moogoo01moo`0300moogoo01moo`0300mo
ogoo01moo`0300moogoo01moo`0300moogoo00=JeQAoo`03001oogoo00Moo`002Goo00<007oo0000
5goo00<007ooOol08goo00<03gooOol07goo00<03gooOol07goo00<03gooOol07goo00<03gooOol0
7goo00@03gooOomoo`9JeQAoo`03001oogoo00Moo`002Goo00<007oo00000goo00<007ooOol00Woo
00@007ooOomoo`<00004Ool000000004Ool00`00Oomoo`0SOol00`0?Oomoo`0OOol00`0?Oomoo`0O
Ool00`0?Oomoo`0OOol00`0?Oomoo`0OOol0100?Oomoogoo0e[F4goo00<007ooOol01goo0009Ool0
0`00Ool00002Ool00`00Ool00008Ool00`00Oomoo`02Ool00`00Oomoo`02Ool2002a00l2F]HA00l3
0009Ool000Qoo`@0009oo`03001oo`0000Qoo`03001oogoo00<000Aoo`03001oogoo02=oo`0300mo
ogoo01moo`0300moogoo01moo`0300moogoo01moo`0300moogoo01moo`0300moogoo01Moo`03001o
ogoo00Moo`003Woo00<007oo000027oo00@007ooOol000Ioo`03001oogoo02=oo`0300moogoo01mo
o`0300moogoo01moo`0300moogoo01moo`0300moogoo01moo`0300moogoo01Moo`03001oogoo00Mo
o`002Woo0`000Woo00<007ooOol01Woo0P000Woo0`0017oo00<007ooOol08goo00<03gooOol07goo
00<03gooOol07goo00<03gooOol07goo00<03gooOol07goo00<03gooOol017oo0U[F4Goo00<007oo
Ool01goo0009Ool01000Oomoo`005Woo00<007ooOol08goo00<03gooOol07goo00<03gooOol07goo
00<03gooOol07goo00<03gooOol07goo00<03gooOol017oo0U[F4Goo00<007ooOol01goo0009Ool0
1000Oomoo`005Woo00<007ooOol08goo00<03gooOol07goo00<03gooOol07goo00<03gooOol07goo
00<03gooOol07goo00<03gooOol017oo0e[F47oo00<007ooOol01goo000:Ool3000FOol00`00Oomo
o`0SOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomo
o`05Ool2F]H?Ool20009Ool000aoo`03001oogoo01Aoo`03001oogoo02=oo`0300moogoo01moo`03
00moogoo01moo`0300moogoo01moo`0300moogoo01moo`0300moogoo00Eoo`9JeQ1oo`03001oogoo
00Moo`002Goo10005Woo00<007ooOol08goo00<03gooOol07goo00<03gooOol07goo00<03gooOol0
7goo00<03gooOol07goo00<03gooOol05goo00<007ooOol01goo000:Ool2000GOol00`00Oomoo`0S
Ool00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0G
Ool00`00Oomoo`07Ool000Uoo`03001oogoo01Moo`03001oogoo02=oo`0300moogoo01moo`0300mo
ogoo01moo`0300moogoo01moo`0300moogoo01moo`0300moogoo00Moo`9JePioo`03001oogoo00Mo
o`002Goo0`005goo00<007ooOol08goo00<03gooOol07goo00<03gooOol07goo00<03gooOol07goo
00<03gooOol07goo00<03gooOol01goo0U[F3Goo0P002Goo000:Ool00`00Oomoo`0FOol00`00Oomo
o`0SOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomo
o`07Ool3F]H=Ool00`00Oomoo`07Ool000]oo`03001oogoo01Eoo`03001oogoo02=oo`0300moogoo
01moo`0300moogoo01moo`0300moogoo01moo`0300moogoo01moo`0300moogoo00Qoo`=JePaoo`03
001oogoo00Moo`002goo00<007ooOol05Goo00<007ooOol08goo00<03gooOol07goo00<03gooOol0
7goo00<03gooOol07goo00<03gooOol07goo00<03gooOol02Goo0U[F37oo00<007ooOol01goo000;
Ool00`00Oomoo`0EOol00`00Oomoo`0SOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0O
Ool00`0?Oomoo`0OOol00`0?Oomoo`0GOol00`00Oomoo`07Ool000]oo`03001oogoo01Eoo`03001o
ogoo02=oo`0300moogoo01moo`0300moogoo01moo`0300moogoo01moo`0300moogoo01moo`0300mo
ogoo01Ioo`8000Uoo`002Woo00<007ooOol05Woo00<007ooOol08goo00<03gooOol07goo00<03goo
Ool07goo00<03gooOol07goo00<03gooOol07goo00<03gooOol02Woo0U[F2goo00<007ooOol01goo
000SOol00`00Oomoo`0SOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomo
o`0OOol00`0?Oomoo`0:Ool2F]H;Ool00`00Oomoo`07Ool002=oo`03001oogoo02=oo`0300moogoo
01moo`0300moogoo01moo`0300moogoo01moo`0300moogoo01moo`0300moogoo00Yoo`=JePYoo`03
001oogoo00Moo`008goo00<007ooOol08goo00<03gooOol07goo00<03gooOol07goo00<03gooOol0
7goo00<03gooOol07goo00<03gooOol02goo0U[F2Woo00<007ooOol01goo000SOol00`00Oomoo`0S
Ool00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0;
Ool3F]H8Ool20009Ool002=oo`03001oogoo02=oo`0300moogoo01moo`0300moogoo01moo`0300mo
ogoo01moo`0300moogoo01moo`0300moogoo00aoo`9JePUoo`03001oogoo00Moo`008goo00<007oo
Ool08goo00<03gooOol07goo00<03gooOol07goo00<03gooOol07goo00<03gooOol07goo00<03goo
Ool05goo00<007ooOol01goo000SOol00`00Oomoo`0SOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol0
0`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0=Ool2F]H8Ool00`00Oomoo`07Ool001Aoo`03
001oogoo009oo`04001oogooOol30003Ool00`00Oomoo`0SOol00`0?Oomoo`0OOol00`0?Oomoo`0O
Ool00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0=Ool2F]H8Ool00`00Oomoo`07Ool001=o
o`03001oo`0000Qoo`03001oogoo009oo`800;`03`=JePD03`<000Uoo`004goo00<007oo00002Goo
00D007ooOomoo`0002Eoo`0300moogoo01moo`0300moogoo01moo`0300moogoo01moo`0300moogoo
01moo`0300moogoo00ioo`9JePMoo`03001oogoo00Moo`004goo00<007oo00002Goo00D007ooOomo
o`0002Eoo`0300moogoo01moo`0300moogoo01moo`0300moogoo01moo`0300moogoo01moo`0300mo
ogoo00ioo`=JePIoo`03001oogoo00Moo`0057oo00<007ooOol01Woo0`000goo00<007ooOol08goo
00<03gooOol07goo00<03gooOol07goo00<03gooOol07goo00<03gooOol07goo00<03gooOol03goo
0U[F1Woo00<007ooOol01goo000SOol00`00Oomoo`0SOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol0
0`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0GOol00`00Oomoo`07Ool002=oo`03001oogoo
02=oo`0300moogoo01moo`0300moogoo01moo`0300moogoo01moo`0300moogoo01moo`0300moogoo
01Ioo`8000Uoo`008goo00<007ooOol08goo00<03gooOol07goo00<03gooOol07goo00<03gooOol0
7goo00<03gooOol07goo00<03gooOol047oo0U[F1Goo00<007ooOol01goo000SOol00`00Oomoo`0S
Ool00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0@
Ool3F]H4Ool00`00Oomoo`07Ool002=oo`03001oogoo02=oo`0300moogoo01moo`0300moogoo01mo
o`0300moogoo01moo`0300moogoo01moo`0300moogoo015oo`9JePAoo`03001oogoo00Moo`008goo
00<007ooOol08goo00<03gooOol07goo00<03gooOol07goo00<03gooOol07goo00<03gooOol07goo
00<03gooOol05goo00<007ooOol01goo000SOol00`00Oomoo`0SOol00`0?Oomoo`0OOol00`0?Oomo
o`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0FOol20009Ool002=oo`03001oogoo
02=oo`0300moogoo01moo`0300moogoo01moo`0300moogoo01moo`0300moogoo01moo`0300moogoo
01Moo`03001oogoo00Moo`008goo00<007ooOol08goo00<03gooOol07goo00<03gooOol07goo00<0
3gooOol07goo00<03gooOol07goo00<03gooOol05goo00<007ooOol01goo000SOol00`00Oomoo`0S
Ool00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0G
Ool00`00Oomoo`07Ool002=oo`03001oogoo02=oo`0300moogoo01moo`0300moogoo01moo`0300mo
ogoo01moo`0300moogoo01moo`0300moogoo015oo`8000Aoo`03001oogoo00Moo`008goo00<007oo
Ool08goo00<03gooOol07goo00<03gooOol07goo00<03gooOol07goo00<03gooOol07goo00<03goo
Ool047oo10000Woo0P002Goo000SOol00`00Oomoo`0SOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol0
0`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0@Ool40003Ool00`00Oomoo`07Ool002=oo`05
001oogooOol0000QOol00`00Oomoo`0OOol00`00Oomoo`0OOol00`00Oomoo`0OOol00`00Oomoo`0O
Ool00`00Oomoo`0AOol20004Ool00`00Oomoo`07Ool002=oolT000Uoo`00\
\>"],
  ImageRangeCache->{{{0, 244}, {150, 0}} -> {14.1419, -0.0568617, 0.146968, 
  0.00195335}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
%% Graphics
/Courier findfont 8  scalefont  setfont
% Scaling calculations
-0.656463 0.0340136 0.0147151 2.20366 [
[(20)] .02381 0 0 2 0 Minner Mrotsboxa
[(25)] .19388 0 0 2 0 Minner Mrotsboxa
[(30)] .36395 0 0 2 0 Minner Mrotsboxa
[(35)] .53401 0 0 2 0 Minner Mrotsboxa
[(40)] .70408 0 0 2 0 Minner Mrotsboxa
[(45)] .87415 0 0 2 0 Minner Mrotsboxa
[(Size of n \\(bits\\))] .5 0 0 2 0 0 -1 Mouter Mrotsboxa
[(0)] -0.0125 .01472 1 0 0 Minner Mrotsboxa
[(0.05)] -0.0125 .1249 1 0 0 Minner Mrotsboxa
[(0.1)] -0.0125 .23508 1 0 0 Minner Mrotsboxa
[(0.15)] -0.0125 .34526 1 0 0 Minner Mrotsboxa
[(0.2)] -0.0125 .45545 1 0 0 Minner Mrotsboxa
[(0.25)] -0.0125 .56563 1 0 0 Minner Mrotsboxa
[(Time \\(seconds\\))] -0.0125 .30902 1 0 90 -1 0 Mouter Mrotsboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 .61903 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
0 0 .5 r
.001 w
.19388 0 m
.19388 .61803 L
s
P
p
0 0 .5 r
.001 w
.36395 0 m
.36395 .61803 L
s
P
p
0 0 .5 r
.001 w
.53401 0 m
.53401 .61803 L
s
P
p
0 0 .5 r
.001 w
.70408 0 m
.70408 .61803 L
s
P
p
0 0 .5 r
.001 w
.87415 0 m
.87415 .61803 L
s
P
p
0 0 .5 r
.001 w
0 .1249 m
1 .1249 L
s
P
p
0 0 .5 r
.001 w
0 .23508 m
1 .23508 L
s
P
p
0 0 .5 r
.001 w
0 .34526 m
1 .34526 L
s
P
p
0 0 .5 r
.001 w
0 .45545 m
1 .45545 L
s
P
p
0 0 .5 r
.001 w
0 .56563 m
1 .56563 L
s
P
p
.002 w
.02381 0 m
.02381 .00625 L
s
P
[(20)] .02381 0 0 2 0 Minner Mrotshowa
p
.002 w
.19388 0 m
.19388 .00625 L
s
P
[(25)] .19388 0 0 2 0 Minner Mrotshowa
p
.002 w
.36395 0 m
.36395 .00625 L
s
P
[(30)] .36395 0 0 2 0 Minner Mrotshowa
p
.002 w
.53401 0 m
.53401 .00625 L
s
P
[(35)] .53401 0 0 2 0 Minner Mrotshowa
p
.002 w
.70408 0 m
.70408 .00625 L
s
P
[(40)] .70408 0 0 2 0 Minner Mrotshowa
p
.002 w
.87415 0 m
.87415 .00625 L
s
P
[(45)] .87415 0 0 2 0 Minner Mrotshowa
p
.001 w
.05782 0 m
.05782 .00375 L
s
P
p
.001 w
.09184 0 m
.09184 .00375 L
s
P
p
.001 w
.12585 0 m
.12585 .00375 L
s
P
p
.001 w
.15986 0 m
.15986 .00375 L
s
P
p
.001 w
.22789 0 m
.22789 .00375 L
s
P
p
.001 w
.2619 0 m
.2619 .00375 L
s
P
p
.001 w
.29592 0 m
.29592 .00375 L
s
P
p
.001 w
.32993 0 m
.32993 .00375 L
s
P
p
.001 w
.39796 0 m
.39796 .00375 L
s
P
p
.001 w
.43197 0 m
.43197 .00375 L
s
P
p
.001 w
.46599 0 m
.46599 .00375 L
s
P
p
.001 w
.5 0 m
.5 .00375 L
s
P
p
.001 w
.56803 0 m
.56803 .00375 L
s
P
p
.001 w
.60204 0 m
.60204 .00375 L
s
P
p
.001 w
.63605 0 m
.63605 .00375 L
s
P
p
.001 w
.67007 0 m
.67007 .00375 L
s
P
p
.001 w
.7381 0 m
.7381 .00375 L
s
P
p
.001 w
.77211 0 m
.77211 .00375 L
s
P
p
.001 w
.80612 0 m
.80612 .00375 L
s
P
p
.001 w
.84014 0 m
.84014 .00375 L
s
P
p
.001 w
.90816 0 m
.90816 .00375 L
s
P
p
.001 w
.94218 0 m
.94218 .00375 L
s
P
p
.001 w
.97619 0 m
.97619 .00375 L
s
P
[(Size of n \\(bits\\))] .5 0 0 2 0 0 -1 Mouter Mrotshowa
p
.002 w
0 0 m
1 0 L
s
P
p
.002 w
0 .01472 m
.00625 .01472 L
s
P
[(0)] -0.0125 .01472 1 0 0 Minner Mrotshowa
p
.002 w
0 .1249 m
.00625 .1249 L
s
P
[(0.05)] -0.0125 .1249 1 0 0 Minner Mrotshowa
p
.002 w
0 .23508 m
.00625 .23508 L
s
P
[(0.1)] -0.0125 .23508 1 0 0 Minner Mrotshowa
p
.002 w
0 .34526 m
.00625 .34526 L
s
P
[(0.15)] -0.0125 .34526 1 0 0 Minner Mrotshowa
p
.002 w
0 .45545 m
.00625 .45545 L
s
P
[(0.2)] -0.0125 .45545 1 0 0 Minner Mrotshowa
p
.002 w
0 .56563 m
.00625 .56563 L
s
P
[(0.25)] -0.0125 .56563 1 0 0 Minner Mrotshowa
p
.001 w
0 .03675 m
.00375 .03675 L
s
P
p
.001 w
0 .05879 m
.00375 .05879 L
s
P
p
.001 w
0 .08082 m
.00375 .08082 L
s
P
p
.001 w
0 .10286 m
.00375 .10286 L
s
P
p
.001 w
0 .14693 m
.00375 .14693 L
s
P
p
.001 w
0 .16897 m
.00375 .16897 L
s
P
p
.001 w
0 .19101 m
.00375 .19101 L
s
P
p
.001 w
0 .21304 m
.00375 .21304 L
s
P
p
.001 w
0 .25712 m
.00375 .25712 L
s
P
p
.001 w
0 .27915 m
.00375 .27915 L
s
P
p
.001 w
0 .30119 m
.00375 .30119 L
s
P
p
.001 w
0 .32323 m
.00375 .32323 L
s
P
p
.001 w
0 .3673 m
.00375 .3673 L
s
P
p
.001 w
0 .38934 m
.00375 .38934 L
s
P
p
.001 w
0 .41137 m
.00375 .41137 L
s
P
p
.001 w
0 .43341 m
.00375 .43341 L
s
P
p
.001 w
0 .47748 m
.00375 .47748 L
s
P
p
.001 w
0 .49952 m
.00375 .49952 L
s
P
p
.001 w
0 .52156 m
.00375 .52156 L
s
P
p
.001 w
0 .54359 m
.00375 .54359 L
s
P
p
.001 w
0 .58767 m
.00375 .58767 L
s
P
p
.001 w
0 .6097 m
.00375 .6097 L
s
P
[(Time \\(seconds\\))] -0.0125 .30902 1 0 90 -1 0 Mouter Mrotshowa
p
.002 w
0 0 m
0 .61803 L
s
P
P
p
p
.002 w
.02381 .61178 m
.02381 .61803 L
s
P
p
.002 w
.19388 .61178 m
.19388 .61803 L
s
P
p
.002 w
.36395 .61178 m
.36395 .61803 L
s
P
p
.002 w
.53401 .61178 m
.53401 .61803 L
s
P
p
.002 w
.70408 .61178 m
.70408 .61803 L
s
P
p
.002 w
.87415 .61178 m
.87415 .61803 L
s
P
p
.001 w
.05782 .61428 m
.05782 .61803 L
s
P
p
.001 w
.09184 .61428 m
.09184 .61803 L
s
P
p
.001 w
.12585 .61428 m
.12585 .61803 L
s
P
p
.001 w
.15986 .61428 m
.15986 .61803 L
s
P
p
.001 w
.22789 .61428 m
.22789 .61803 L
s
P
p
.001 w
.2619 .61428 m
.2619 .61803 L
s
P
p
.001 w
.29592 .61428 m
.29592 .61803 L
s
P
p
.001 w
.32993 .61428 m
.32993 .61803 L
s
P
p
.001 w
.39796 .61428 m
.39796 .61803 L
s
P
p
.001 w
.43197 .61428 m
.43197 .61803 L
s
P
p
.001 w
.46599 .61428 m
.46599 .61803 L
s
P
p
.001 w
.5 .61428 m
.5 .61803 L
s
P
p
.001 w
.56803 .61428 m
.56803 .61803 L
s
P
p
.001 w
.60204 .61428 m
.60204 .61803 L
s
P
p
.001 w
.63605 .61428 m
.63605 .61803 L
s
P
p
.001 w
.67007 .61428 m
.67007 .61803 L
s
P
p
.001 w
.7381 .61428 m
.7381 .61803 L
s
P
p
.001 w
.77211 .61428 m
.77211 .61803 L
s
P
p
.001 w
.80612 .61428 m
.80612 .61803 L
s
P
p
.001 w
.84014 .61428 m
.84014 .61803 L
s
P
p
.001 w
.90816 .61428 m
.90816 .61803 L
s
P
p
.001 w
.94218 .61428 m
.94218 .61803 L
s
P
p
.001 w
.97619 .61428 m
.97619 .61803 L
s
P
p
.002 w
0 .61803 m
1 .61803 L
s
P
p
.002 w
.99375 .01472 m
1 .01472 L
s
P
p
.002 w
.99375 .1249 m
1 .1249 L
s
P
p
.002 w
.99375 .23508 m
1 .23508 L
s
P
p
.002 w
.99375 .34526 m
1 .34526 L
s
P
p
.002 w
.99375 .45545 m
1 .45545 L
s
P
p
.002 w
.99375 .56563 m
1 .56563 L
s
P
p
.001 w
.99625 .03675 m
1 .03675 L
s
P
p
.001 w
.99625 .05879 m
1 .05879 L
s
P
p
.001 w
.99625 .08082 m
1 .08082 L
s
P
p
.001 w
.99625 .10286 m
1 .10286 L
s
P
p
.001 w
.99625 .14693 m
1 .14693 L
s
P
p
.001 w
.99625 .16897 m
1 .16897 L
s
P
p
.001 w
.99625 .19101 m
1 .19101 L
s
P
p
.001 w
.99625 .21304 m
1 .21304 L
s
P
p
.001 w
.99625 .25712 m
1 .25712 L
s
P
p
.001 w
.99625 .27915 m
1 .27915 L
s
P
p
.001 w
.99625 .30119 m
1 .30119 L
s
P
p
.001 w
.99625 .32323 m
1 .32323 L
s
P
p
.001 w
.99625 .3673 m
1 .3673 L
s
P
p
.001 w
.99625 .38934 m
1 .38934 L
s
P
p
.001 w
.99625 .41137 m
1 .41137 L
s
P
p
.001 w
.99625 .43341 m
1 .43341 L
s
P
p
.001 w
.99625 .47748 m
1 .47748 L
s
P
p
.001 w
.99625 .49952 m
1 .49952 L
s
P
p
.001 w
.99625 .52156 m
1 .52156 L
s
P
p
.001 w
.99625 .54359 m
1 .54359 L
s
P
p
.001 w
.99625 .58767 m
1 .58767 L
s
P
p
.001 w
.99625 .6097 m
1 .6097 L
s
P
p
.002 w
1 0 m
1 .61803 L
s
P
P
p
P
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
p
p
[ .02 .02 ] 0 setdash
p
2 Mabswid
.02381 .01627 m
.06349 .0167 L
.10317 .01726 L
.14286 .01797 L
.18254 .01889 L
.22222 .02006 L
.2619 .02156 L
.30159 .02348 L
.34127 .02595 L
.38095 .0291 L
.42063 .03314 L
.46032 .03831 L
.5 .04493 L
.53968 .05342 L
.57937 .06428 L
.61905 .0782 L
.65873 .09602 L
.69841 .11885 L
.7381 .14808 L
.77778 .18553 L
.81746 .23348 L
.85714 .2949 L
.89683 .37356 L
.93651 .4743 L
.97619 .60332 L
s
P
P
p
p
.02 w
.02381 .01754 Mdot
.15986 .01743 Mdot
.29592 .01883 Mdot
.43197 .03198 Mdot
.56803 .07829 Mdot
.70408 .16662 Mdot
.84014 .27508 Mdot
.97619 .52156 Mdot
P
P
P
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{245, 151},
  ImageMargins->{{34, Inherited}, {Inherited, Inherited}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003e0000Ua000`40O003h00OmGoo003eOol00?Eo
o`00Tgoo00<007ooOol057oo00<007ooOol0B7oo001QOol9000017oo000000000Woo0`001goo0P00
0Woo10001Goo00<007oo000027oo00@007ooOomoo`<00003Ool0000000H0009oo`<000Aoo`03001o
ogoo04Moo`00HGoo00@007ooOol0009oo`04001oogooOol20002Ool00`00Oomoo`07Ool01000Oomo
o`000Woo00<007ooOol01Goo00<007oo000027oo00D007ooOomoo`00009oo`04001oogoo0002Ool0
0`00Oomoo`03Ool20004Ool00`00Oomoo`17Ool0069oo`8000=oo`03001oogoo009oo`800003Ool0
0000008000Ioo`04001oogoo0002Ool00`00Oomoo`05Ool00`00Ool00008Ool01@00Oomoogoo0000
0Woo00@007ooOol0009oo`03001oogoo009oo`03001oogoo00Aoo`03001oogoo04Moo`00HGoo00D0
07ooOol007oo008000=oo`<0009oo`8000Qoo`80009oo`@000Aoo`@000Qoo`04001oogooOol30002
Ool200000goo000000020002Ool30004Ool00`00Oomoo`17Ool0065oo`@001Yoo`03001oogoo015o
o`04001oogoo0008Ool00`00Oomoo`08Ool00`00Oomoo`18Ool006Moo`03001oogoo01Eoo`<001=o
o`8000Eoo`03001oogoo05Ioo`00mGoo003eOol00?Eoo`00mGoo003eOol00?Eoo`00mGoo003eOol0
02Aoo`<000=oo`03001oogoo01Uoo`<0009oo`<001Yoo`<000=oo`03001oogoo01Uoo`<0009oo`<0
01aoo`05001oogooOol0000MOol00`00Oomoo`03000OOol002Eoo`07001oogooOol007oo00006goo
00<007ooOol00goo00<007ooOol06Woo00H007ooOol007oo000LOol00`00Oomoo`02Ool00`00Oomo
o`0HOol30002Ool00`00Ool0000JOol30004Ool00`00Oomoo`0MOol002Ioo`06001oogoo001oo`00
77oo00<007ooOol00`006goo00L007ooOomoo`00Ool0000KOol01000Oomoogoo0`006Woo00<007oo
00000Woo00<007oo00006Woo00<007oo00000Woo0`007goo000VOol01P00Oomoo`00Ool001aoo`04
001oogoo000NOol01P00Oomoo`00Ool001aoo`04001oogoo000MOol20002Ool00`00Ool0000KOol2
0002Ool00`00Oomoo`0OOol002Aoo`<000=oo`03001oogoo01Uoo`<0009oo`<001Yoo`<000=oo`03
001oogoo01Uoo`<0009oo`<001aoo`05001oogooOol0000MOol00`00Oomoo`03000OOol00?Eoo`00
mGoo003eOol00?Eoo`008goob@002Goo000SOol01@00Oomoogoo00008Goo00<007ooOol07goo00<0
07ooOol07goo00<007ooOol07goo00<007ooOol07goo00<007ooOol05goo00<007ooOol01goo000M
Ool00`00Oomoo`03Ool01000Oomoogoo0P006Goo0P001Goo00<03gooOol04Goo0P0037oo00<03goo
Ool07goo00<03gooOol07goo00<03gooOol07goo00<03gooOol05goo00<007ooOol01goo000LOol0
0`00Ool00004Ool200000goo000000040002Ool60002Ool60002Ool70004Ool00`0?Oomoo`0@Ool4
000;Ool00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0EOol30009Ool0
01aoo`03001oo`0000Aoo`03001oogoo00H0009oo`H0009oo`H0009oo`L00003Ool0000000@0009o
o`H0009oo``000Uoo`0300moogoo01moo`0300moogoo01moo`0300moogoo01moo`0300moogoo01Mo
o`03001oogoo00Moo`0077oo00<007oo000017oo00@007ooOomoo`8001Uoo`80009oo`H0009oo`H0
009oo`H00003Ool0000000D0009oo`H000eoo`80019oo`0300moogoo01moo`0300moogoo01moo`03
00moogoo01Moo`03001oogoo00Moo`007Goo00<007ooOol00goo00<007ooOol08goo00<03gooOol0
5Goo0`000Woo1P000Woo1P000Woo1P004Goo00<03gooOol07goo00<03gooOol07goo00<03gooOol0
5goo00<007ooOol01goo000SOol00`00Oomoo`0SOol00`0?Oomoo`0OOol00`0?Oomoo`060002Ool6
0002Ool4000;Ool00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0FOol20009Ool002=oo`03
001oogoo02=oo`0300moogoo01moo`0300moogoo00]oo`<0009oo`H000Uoo`0300moogoo01moo`03
00moogoo01moo`0300moogoo01Moo`03001oogoo00Moo`008goo00<007ooOol08goo00<03gooOol0
7goo00<03gooOol04goo0`000Woo10000goo00<03gooOol07goo00<03gooOol07goo00<03gooOol0
5goo00<007ooOol01goo000SOol00`00Oomoo`0SOol00`0?Oomoo`0OOol00`0?Oomoo`0HOol60000
0goo00l00002000NOol00`0?Oomoo`0OOol00`0?Oomoo`0GOol00`00Oomoo`07Ool002=oo`03001o
ogoo02=oo`0300moogoo01moo`0300moogoo01]oo`<00003Ool03`0000@001aoo`0300moogoo01mo
o`0300moogoo01Ioo`8000Uoo`008goo00<007ooOol08goo00<03gooOol07goo00<03gooOol07goo
00<03gooOol010006goo00<03gooOol07goo00<03gooOol05goo00<007ooOol01goo000SOol00`00
Oomoo`0SOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`02Ool20002Ool4000EOol00`0?
Oomoo`0OOol00`0?Oomoo`0GOol00`00Oomoo`07Ool002=oo`03001oogoo02=oo`0300moogoo01mo
o`0300moogoo01moo`0300moogoo00Aoo`L001Aoo`0300moogoo01moo`0300moogoo01Moo`03001o
ogoo00Moo`008goo00<007ooOol08goo00<03gooOol07goo00<03gooOol07goo00<03gooOol00goo
10000Woo0P000Woo0`003goo00<03gooOol07goo00<03gooOol05goo00<007ooOol01goo000SOol0
0`00Oomoo`0SOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`03Ool40006Ool5000=Ool0
0`0?Oomoo`0OOol00`0?Oomoo`0FOol20009Ool002=oo`03001oogoo02=oo`0300moogoo01moo`03
00moogoo01moo`0300moogoo00Aoo`8000Uoo`@000aoo`0300moogoo01moo`0300moogoo01Moo`03
001oogoo00Moo`008goo00<007ooOol08goo00<03gooOol07goo00<03gooOol07goo00<03gooOol0
4Goo0P0000=oo`0000002Goo00<03gooOol07goo00<03gooOol05goo00<007ooOol01goo000SOol0
0`00Oomoo`0SOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0DOol50006Ool00`0?Oomo
o`0OOol00`0?Oomoo`0GOol00`00Oomoo`07Ool002=oo`03001oogoo02=oo`0300moogoo01moo`03
00moogoo01moo`0300moogoo01Eoo`D000Eoo`0300moogoo01moo`0300moogoo01Ioo`8000Uoo`00
8goo00<007ooOol08goo00<03gooOol07goo00<03gooOol07goo00<03gooOol067oo0P001Goo00<0
3gooOol07goo00<03gooOol05goo00<007ooOol01goo000SOol00`00Oomoo`0SOol00`0?Oomoo`0O
Ool00`0?Oomoo`0OOol00`0?Oomoo`0KOol300000goo00moo`0POol00`0?Oomoo`0GOol00`00Oomo
o`07Ool002=oo`03001oogoo02=oo`0300moogoo01moo`0300moogoo01moo`0300moogoo01]oo`@0
000300moogoo01moo`0300moogoo01Moo`03001oogoo00Moo`003goo00<007ooOol00Woo00<007oo
Ool00Woo00<007ooOol00`0017oo00<007ooOol08goo00<03gooOol07goo00<03gooOol07goo00<0
3gooOol07Goo0`008Goo00<03gooOol05goo00<007ooOol01goo000>Ool00`00Ool00007Ool00`00
Ool00003Ool00`00Oomoo`02Ool2002900l3000h00l30009Ool000ioo`03001oo`0000Moo`04001o
o`00Ool30004Ool00`00Oomoo`0SOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol2
000POol00`0?Oomoo`0GOol00`00Oomoo`07Ool000ioo`03001oo`0000Moo`05001oo`00Ool00006
Ool00`00Oomoo`0SOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`03
000LOol00`0?Oomoo`0GOol00`00Oomoo`07Ool000moo`03001oogoo00Moo`03001oogoo00<000Ao
o`03001oogoo02=oo`0300moogoo01moo`0300moogoo01moo`0300moogoo01moo`0300moogoo00@0
01]oo`0300moogoo01Moo`03001oogoo00Moo`002Goo0`005goo00<007ooOol08goo00<03gooOol0
7goo00<03gooOol07goo00<03gooOol07goo00<03gooOol00Woo0`006Woo00<03gooOol05Woo0P00
2Goo000:Ool00`00Oomoo`0FOol00`00Oomoo`0SOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?
Oomoo`0OOol00`0?Oomoo`03Ool2000JOol00`0?Oomoo`0GOol00`00Oomoo`07Ool000Yoo`03001o
ogoo01Ioo`03001oogoo02=oo`0300moogoo01moo`0300moogoo01moo`0300moogoo01moo`80021o
o`0300moogoo01Moo`03001oogoo00Moo`0027oo00D007oo001oo`0001Ioo`03001oogoo02=oo`03
00moogoo01moo`0300moogoo01moo`0300moogoo01ioo`@000Ioo`8001Moo`0300moogoo01Moo`03
001oogoo00Moo`0027oo1@005Woo00<007ooOol08goo00<03gooOol07goo00<03gooOol07goo00<0
3gooOol07Woo10001Woo0`005Woo00<03gooOol05Woo0P002Goo0008Ool5000FOol00`00Oomoo`0S
Ool00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol20008Ool3000EOol00`0?Oomoo`0G
Ool00`00Oomoo`07Ool000Yoo`03001oogoo01Ioo`03001oogoo02=oo`0300moogoo01moo`0300mo
ogoo01moo`0300moogoo01moo`0300moogoo00Qoo`<001Aoo`0300moogoo01Moo`03001oogoo00Mo
o`002Woo00<007ooOol05Woo00<007ooOol08goo00<03gooOol07goo00<03gooOol07goo00<03goo
Ool07goo00<03gooOol02Goo0P0057oo00<03gooOol05goo00<007ooOol01goo0009Ool2000HOol0
0`00Oomoo`0SOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol0
0`0?Oomoo`0GOol00`00Oomoo`07Ool002=oo`03001oogoo02=oo`0300moogoo01moo`0300moogoo
01moo`0300moogoo01moo`0300moogoo00aoo`80015oo`0300moogoo01Ioo`8000Uoo`0027oo00D0
07oo001oo`0001Ioo`03001oogoo02=oo`0300moogoo01moo`0300moogoo01moo`0300moogoo01mo
o`0300moogoo00aoo`80015oo`0300moogoo01Moo`03001oogoo00Moo`0027oo00D007oo001oo`00
01Ioo`03001oogoo02=oo`0300moogoo01moo`0300moogoo01moo`0300moogoo01moo`0300moogoo
00aoo`<0011oo`0300moogoo01Moo`03001oogoo00Moo`0027oo00D007oo001oo`0001Ioo`03001o
ogoo02=oo`0300moogoo01moo`0300moogoo01moo`0300moogoo01moo`0300moogoo00eoo`<000mo
o`0300moogoo01Moo`03001oogoo00Moo`0027oo1@005Woo00<007ooOol08goo00<03gooOol07goo
00<03gooOol07goo00<03gooOol07goo00<03gooOol03Woo0P003goo00<03gooOol05Woo0P002Goo
000SOol00`00Oomoo`0SOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomo
o`0OOol00`0?Oomoo`0GOol00`00Oomoo`07Ool000Yoo`<001Ioo`03001oogoo02=oo`0300moogoo
01moo`0300moogoo01moo`0300moogoo01moo`0300moogoo015oo`8000aoo`0300moogoo01Moo`03
001oogoo00Moo`002Goo00<007ooOol05goo00<007ooOol08goo00<03gooOol07goo00<03gooOol0
7goo00<03gooOol07goo00<03gooOol04Goo0`002goo00<03gooOol05goo00<007ooOol01goo0009
Ool40007Ool00`00Oomoo`02Ool01000Oomoogoo0`000goo00<007ooOol08goo00<03gooOol07goo
00<03gooOol07goo00<03gooOol07goo00<03gooOol04Woo0`002Woo00<03gooOol05goo00<007oo
Ool01goo000:Ool20007Ool00`00Ool00008Ool00`00Oomoo`02Ool2002P00l2000R00l30009Ool0
01=oo`03001oo`0000Qoo`03001oogoo009oo`03001oogoo02=oo`0300moogoo01moo`0300moogoo
01moo`0300moogoo01moo`0300moogoo01=oo`8000Yoo`0300moogoo01Moo`03001oogoo00Moo`00
4goo00<007oo000027oo00<007ooOol00Woo00<007ooOol08goo00<03gooOol07goo00<03gooOol0
7goo00<03gooOol07goo00<03gooOol07goo00<03gooOol05goo00<007ooOol01goo000DOol00`00
Oomoo`06Ool20004Ool00`00Oomoo`0SOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0O
Ool00`0?Oomoo`0FOol20007Ool00`0?Oomoo`0GOol00`00Oomoo`07Ool002=oo`03001oogoo02=o
o`0300moogoo01moo`0300moogoo01moo`0300moogoo01moo`0300moogoo01Ioo`8000Moo`0300mo
ogoo01Ioo`8000Uoo`002goo00<007ooOol05Goo00<007ooOol08goo00<03gooOol07goo00<03goo
Ool07goo00<03gooOol07goo00<03gooOol05Woo0`001Woo00<03gooOol05goo00<007ooOol01goo
000:Ool00`00Oomoo`0FOol00`00Oomoo`0SOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomo
o`0OOol00`0?Oomoo`0GOol30005Ool00`0?Oomoo`0GOol00`00Oomoo`07Ool000Yoo`03001oogoo
01Ioo`03001oogoo02=oo`0300moogoo01moo`0300moogoo01moo`0300moogoo01moo`0300moogoo
01Moo`@000Aoo`0300moogoo01Moo`03001oogoo00Moo`002Woo00<007ooOol05Woo00<007ooOol0
8goo00<03gooOol07goo00<03gooOol07goo00<03gooOol07goo00<03gooOol05goo100017oo00<0
3gooOol05goo00<007ooOol01goo000:Ool00`00Oomoo`0FOol00`00Oomoo`0SOol00`0?Oomoo`0O
Ool00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0HOol20005Ool00`0?Oomoo`0FOol20009
Ool000]oo`03001oogoo01Eoo`03001oogoo02=oo`0300moogoo01moo`0300moogoo01moo`0300mo
ogoo01moo`0300moogoo01Yoo`8000=oo`0300moogoo01Moo`03001oogoo00Moo`002Goo0`005goo
00<007ooOol08goo00<03gooOol07goo00<03gooOol07goo00<03gooOol07goo00<03gooOol06Woo
0P000goo00<03gooOol05goo00<007ooOol01goo000:Ool2000GOol00`00Oomoo`0SOol00`0?Oomo
o`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0JOol30002Ool00`0?Oomoo`0GOol0
0`00Oomoo`07Ool000Uoo`03001oogoo01Moo`03001oogoo02=oo`0300moogoo01moo`0300moogoo
01moo`0300moogoo01moo`0300moogoo01]oo`<00003Ool03goo01Moo`8000Uoo`002Goo0`005goo
00<007ooOol08goo00<03gooOol07goo00<03gooOol07goo00<03gooOol07goo00<03gooOol077oo
0P0000=oo`0?Ool067oo00<007ooOol01goo000SOol00`00Oomoo`0SOol00`0?Oomoo`0OOol00`0?
Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0GOol00`00Oomoo`07Ool000Yo
o`<001Ioo`03001oogoo02=oo`0300moogoo01moo`0300moogoo01moo`0300moogoo01moo`0300mo
ogoo01moo`0300moogoo01Moo`03001oogoo00Moo`002Goo00<007ooOol05goo00<007ooOol08goo
00<03gooOol07goo00<03gooOol07goo00<03gooOol07goo00<03gooOol07Woo0P0067oo0P002Goo
0009Ool4000FOol00`00Oomoo`0SOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol0
0`0?Oomoo`0NOol2000IOol00`00Oomoo`07Ool000Yoo`8001Moo`03001oogoo02=oo`0300moogoo
01moo`0300moogoo01moo`0300moogoo01moo`0300moogoo01ioo`<001Qoo`03001oogoo00Moo`00
8goo00<007ooOol08goo00<03gooOol07goo00<03gooOol07goo00<03gooOol07goo00<03gooOol0
7goo0P0067oo00<007ooOol01goo000:Ool20003Ool00`00Oomoo`02Ool01000Oomoogoo0`0000Ao
o`00000000Aoo`03001oogoo02=oo`0300moogoo01moo`0300moogoo01moo`0300moogoo01moo`03
00moogoo01moo`<001Moo`03001oogoo00Moo`002Goo00P007ooOol007oo001oo`0027oo00<007oo
Ool00Woo00<007ooOol00Woo0P00[@0?0P005@0?0`002Goo0009Ool02000Oomoo`00Ool007oo0008
Ool00`00Oomoo`030004Ool00`00Oomoo`0SOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomo
o`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0GOol00`00Oomoo`07Ool000Yoo`<00004Ool007oo0008
Ool01000Oomoo`001Woo00<007ooOol08goo00<03gooOol07goo00<03gooOol07goo00<03gooOol0
7goo00<03gooOol07goo00@03goo000001Ioo`03001oogoo00Moo`002Woo0P000goo00<007ooOol0
1Woo0P000Woo0`0017oo00<007ooOol08goo00<03gooOol07goo00<03gooOol07goo00<03gooOol0
7goo00<03gooOol07goo00@03goo000001Ioo`03001oogoo00Moo`002Goo00@007ooOol001Ioo`03
001oogoo02=oo`0300moogoo01moo`0300moogoo01moo`0300moogoo01moo`0300moogoo01moo`03
00moo`00008001Aoo`8000Uoo`002Goo00@007ooOol001Ioo`03001oogoo02=oo`0300moogoo01mo
o`0300moogoo01moo`0300moogoo01moo`0300moogoo01moo`0300moogoo00<001Aoo`03001oogoo
00Moo`002Woo0P005goo00<007ooOol08goo00<03gooOol07goo00<03gooOol07goo00<03gooOol0
7goo00<03gooOol07goo00@03gooOomoo`8001Aoo`03001oogoo00Moo`008goo00<007ooOol08goo
00<03gooOol07goo00<03gooOol07goo00<03gooOol07goo00<03gooOol07goo00@03gooOomoo`80
01Aoo`03001oogoo00Moo`002Goo00<007oo00005goo00<007ooOol08goo00<03gooOol07goo00<0
3gooOol07goo00<03gooOol07goo00<03gooOol07goo00<03gooOol05goo00<007ooOol01goo0009
Ool00`00Ool0000GOol00`00Oomoo`0SOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0O
Ool00`0?Oomoo`0OOol00`0?Oomoo`03Ool2000AOol20009Ool000Uoo`03001oo`0001Moo`03001o
ogoo02=oo`0300moogoo01moo`0300moogoo01moo`0300moogoo01moo`0300moogoo01moo`0300mo
ogoo00=oo`80019oo`03001oogoo00Moo`0027oo10005goo00<007ooOol08goo00<03gooOol07goo
00<03gooOol07goo00<03gooOol07goo00<03gooOol07goo00<03gooOol00goo0P004Woo00<007oo
Ool01goo000SOol00`00Oomoo`0SOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol0
0`0?Oomoo`0OOol00`0?Oomoo`03Ool3000AOol00`00Oomoo`07Ool000Yoo`<001Ioo`03001oogoo
02=oo`0300moogoo01moo`0300moogoo01moo`0300moogoo01moo`0300moogoo01moo`0300moogoo
00Aoo`80011oo`8000Uoo`002Goo00@007ooOol001Ioo`03001oogoo02=oo`0300moogoo01moo`03
00moogoo01moo`0300moogoo01moo`0300moogoo01moo`0300moogoo00Aoo`80015oo`03001oogoo
00Moo`002Goo00@007ooOol001Ioo`03001oogoo02=oo`0300moogoo01moo`0300moogoo01moo`03
00moogoo01moo`0300moogoo01moo`0300moogoo01Moo`03001oogoo00Moo`002Woo0`005Woo00<0
07ooOol08goo00<03gooOol07goo00<03gooOol07goo00<03gooOol07goo00<03gooOol07goo00<0
3gooOol05goo00<007ooOol01goo000<Ool00`00Oomoo`0DOol00`00Oomoo`0SOol00`0?Oomoo`0O
Ool00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`06Ool2000>Ool20009
Ool000Uoo`@001Ioo`03001oogoo02=oo`0300moogoo01moo`0300moogoo01moo`0300moogoo01mo
o`0300moogoo01moo`0300moogoo00Ioo`8000moo`03001oogoo00Moo`002Woo0P005goo00<007oo
Ool08goo00<03gooOol07goo00<03gooOol07goo00<03gooOol07goo00<03gooOol07goo00<03goo
Ool01Woo0P003goo00<007ooOol01goo0009Ool00`00Oomoo`0GOol00`00Oomoo`0SOol00`0?Oomo
o`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`06Ool3000>Ool0
0`00Oomoo`07Ool000Uoo`<000Qoo`03001oogoo009oo`04001oogooOol30003Ool00`00Oomoo`0S
Ool00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`07
Ool2000>Ool00`00Oomoo`07Ool000Yoo`03001oogoo00Ioo`03001oo`0000Qoo`03001oogoo009o
o`800;H03`8000`03`<000Uoo`002goo00<007ooOol01Goo00<007oo00002Goo00D007ooOomoo`00
02Eoo`0300moogoo01moo`0300moogoo01moo`0300moogoo01moo`0300moogoo01moo`0300moogoo
01Moo`03001oogoo00Moo`002goo00<007ooOol01Goo00<007oo00002Goo00D007ooOomoo`0002Eo
o`0300moogoo01moo`0300moogoo01moo`0300moogoo01moo`0300moogoo01moo`0300moogoo00Qo
o`8000eoo`03001oogoo00Moo`002goo00<007ooOol01Woo00<007ooOol01Woo0`000goo00<007oo
Ool08goo00<03gooOol07goo00<03gooOol07goo00<03gooOol07goo00<03gooOol07goo00<03goo
Ool027oo0P003Goo00<007ooOol01goo000;Ool00`00Oomoo`0EOol00`00Oomoo`0SOol00`0?Oomo
o`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`08Ool3000;Ool2
0009Ool000Yoo`03001oogoo01Ioo`03001oogoo02=oo`0300moogoo01moo`0300moogoo01moo`03
00moogoo01moo`0300moogoo01moo`0300moogoo00Uoo`8000aoo`03001oogoo00Moo`008goo00<0
07ooOol08goo00<03gooOol07goo00<03gooOol07goo00<03gooOol07goo00<03gooOol07goo00<0
3gooOol02Goo0`002goo00<007ooOol01goo000SOol00`00Oomoo`0SOol00`0?Oomoo`0OOol00`0?
Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0:Ool2000;Ool00`00Oomoo`07
Ool002=oo`03001oogoo02=oo`0300moogoo01moo`0300moogoo01moo`0300moogoo01moo`0300mo
ogoo01moo`0300moogoo01Moo`03001oogoo00Moo`008goo00<007ooOol08goo00<03gooOol07goo
00<03gooOol07goo00<03gooOol07goo00<03gooOol07goo00<03gooOol05Woo0P002Goo000SOol0
0`00Oomoo`0SOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol0
0`0?Oomoo`0;Ool2000:Ool00`00Oomoo`07Ool002=oo`03001oogoo02=oo`0300moogoo01moo`03
00moogoo01moo`0300moogoo01moo`0300moogoo01moo`0300moogoo00]oo`8000Aoo`8000Aoo`03
001oogoo00Moo`008goo00<007ooOol08goo00<03gooOol07goo00<03gooOol07goo00<03gooOol0
7goo00<03gooOol07goo00<03gooOol02goo0P000goo10000goo00<007ooOol01goo000SOol00`00
Oomoo`0SOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?
Oomoo`0;Ool30002Ool40002Ool20009Ool002=oo`03001oogoo02=oo`0300moogoo01moo`0300mo
ogoo01moo`0300moogoo01moo`0300moogoo01moo`0300moogoo00aoo`8000=oo`8000Aoo`03001o
ogoo00Moo`008goo00<007ooOol08goo00<03gooOol07goo00<03gooOol07goo00<03gooOol07goo
00<03gooOol07goo00<03gooOol037oo0P002Goo00<007ooOol01goo000SOol00`00Oomoo`0SOol0
0`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0GOol0
0`00Oomoo`07Ool002=oo`03001oogoo02=oo`0300moogoo01moo`0300moogoo01moo`0300moogoo
01moo`0300moogoo01moo`0300moogoo01Ioo`8000Uoo`008goo00<007ooOol08goo00<03gooOol0
7goo00<03gooOol07goo00<03gooOol07goo00<03gooOol07goo00<03gooOol03Goo0P0027oo00<0
07ooOol01goo000SOol00`00Oomoo`0SOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0O
Ool00`0?Oomoo`0OOol00`0?Oomoo`0=Ool20008Ool00`00Oomoo`07Ool002=oo`03001oogoo02=o
o`0300moogoo01moo`0300moogoo01moo`0300moogoo01moo`0300moogoo01moo`0300moogoo00eo
o`<000Moo`03001oogoo00Moo`003goo00<007ooOol00Woo00@007ooOomoo`<00004Ool000000004
Ool00`00Oomoo`0SOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0O
Ool00`0?Oomoo`0>Ool20007Ool00`00Oomoo`07Ool000ioo`03001oo`0000Qoo`03001oogoo009o
o`03001oogoo009oo`800;d03`8000D03`<000Uoo`003Woo00<007oo00002Goo00<007oo00000P00
17oo00<007ooOol08goo00<03gooOol07goo00<03gooOol07goo00<03gooOol07goo00<03gooOol0
7goo00<03gooOol05goo00<007ooOol01goo000>Ool00`00Ool00009Ool00`00Ool00006Ool00`00
Oomoo`0SOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?
Oomoo`0GOol00`00Oomoo`07Ool000moo`03001oogoo00Ioo`<00004Ool000000004Ool00`00Oomo
o`0SOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomo
o`0@Ool20005Ool00`00Oomoo`07Ool002=oo`03001oogoo02=oo`0300moogoo01moo`0300moogoo
01moo`0300moogoo01moo`0300moogoo01moo`0300moogoo011oo`8000Aoo`8000Uoo`008goo00<0
07ooOol08goo00<03gooOol07goo00<03gooOol07goo00<03gooOol07goo00<03gooOol07goo00<0
3gooOol047oo0P001Goo00<007ooOol01goo000SOol00`00Oomoo`0SOol00`0?Oomoo`0OOol00`0?
Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0@Ool30004Ool00`00Oomoo`07
Ool002=oo`03001oogoo02=oo`0300moogoo01moo`0300moogoo01moo`0300moogoo01moo`0300mo
ogoo01moo`0300moogoo015oo`8000Aoo`03001oogoo00Moo`008goo00<007ooOol08goo00<03goo
Ool07goo00<03gooOol07goo00<03gooOol07goo00<03gooOol07goo00<03gooOol04Goo0P0017oo
00<007ooOol01goo000SOol01@00Oomoogoo00008Goo00<007ooOol07goo00<007ooOol07goo00<0
07ooOol07goo00<007ooOol07goo00<007ooOol05Woo0P002Goo000SOoo90009Ool00001\
\>"],
  ImageRangeCache->{{{0, 244}, {150, 0}} -> {14.1419, -0.0660345, 0.146968, 
  0.00226846}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
%% Graphics
/Courier findfont 8  scalefont  setfont
% Scaling calculations
-0.656463 0.0340136 0.768774 0.259223 [
[(20)] .02381 0 0 2 0 Minner Mrotsboxa
[(25)] .19388 0 0 2 0 Minner Mrotsboxa
[(30)] .36395 0 0 2 0 Minner Mrotsboxa
[(35)] .53401 0 0 2 0 Minner Mrotsboxa
[(40)] .70408 0 0 2 0 Minner Mrotsboxa
[(45)] .87415 0 0 2 0 Minner Mrotsboxa
[(Size of n \\(bits\\))] .5 0 0 2 0 0 -1 Mouter Mrotsboxa
[(0.002)] -0.0125 .06914 1 0 0 Minner Mrotsboxa
[(0.005)] -0.0125 .17229 1 0 0 Minner Mrotsboxa
[(0.01)] -0.0125 .25033 1 0 0 Minner Mrotsboxa
[(0.02)] -0.0125 .32836 1 0 0 Minner Mrotsboxa
[(0.05)] -0.0125 .43152 1 0 0 Minner Mrotsboxa
[(0.1)] -0.0125 .50955 1 0 0 Minner Mrotsboxa
[(0.2)] -0.0125 .58758 1 0 0 Minner Mrotsboxa
[(Time \\(seconds\\))] -0.0125 .30902 1 0 90 -1 0 Mouter Mrotsboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 .61903 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
0 0 .5 r
.001 w
.19388 0 m
.19388 .61803 L
s
P
p
0 0 .5 r
.001 w
.36395 0 m
.36395 .61803 L
s
P
p
0 0 .5 r
.001 w
.53401 0 m
.53401 .61803 L
s
P
p
0 0 .5 r
.001 w
.70408 0 m
.70408 .61803 L
s
P
p
0 0 .5 r
.001 w
.87415 0 m
.87415 .61803 L
s
P
p
0 0 .5 r
.001 w
0 .06914 m
1 .06914 L
s
P
p
0 0 .5 r
.001 w
0 .17229 m
1 .17229 L
s
P
p
0 0 .5 r
.001 w
0 .25033 m
1 .25033 L
s
P
p
0 0 .5 r
.001 w
0 .32836 m
1 .32836 L
s
P
p
0 0 .5 r
.001 w
0 .43152 m
1 .43152 L
s
P
p
0 0 .5 r
.001 w
0 .50955 m
1 .50955 L
s
P
p
0 0 .5 r
.001 w
0 .58758 m
1 .58758 L
s
P
p
0 0 .5 r
.001 w
0 .11479 m
1 .11479 L
s
P
p
0 0 .5 r
.001 w
0 .14717 m
1 .14717 L
s
P
p
0 0 .5 r
.001 w
0 .19282 m
1 .19282 L
s
P
p
0 0 .5 r
.001 w
0 .21017 m
1 .21017 L
s
P
p
0 0 .5 r
.001 w
0 .22521 m
1 .22521 L
s
P
p
0 0 .5 r
.001 w
0 .23847 m
1 .23847 L
s
P
p
0 0 .5 r
.001 w
0 .37401 m
1 .37401 L
s
P
p
0 0 .5 r
.001 w
0 .4064 m
1 .4064 L
s
P
p
0 0 .5 r
.001 w
0 .45204 m
1 .45204 L
s
P
p
0 0 .5 r
.001 w
0 .4694 m
1 .4694 L
s
P
p
0 0 .5 r
.001 w
0 .48443 m
1 .48443 L
s
P
p
0 0 .5 r
.001 w
0 .49769 m
1 .49769 L
s
P
p
.002 w
.02381 0 m
.02381 .00625 L
s
P
[(20)] .02381 0 0 2 0 Minner Mrotshowa
p
.002 w
.19388 0 m
.19388 .00625 L
s
P
[(25)] .19388 0 0 2 0 Minner Mrotshowa
p
.002 w
.36395 0 m
.36395 .00625 L
s
P
[(30)] .36395 0 0 2 0 Minner Mrotshowa
p
.002 w
.53401 0 m
.53401 .00625 L
s
P
[(35)] .53401 0 0 2 0 Minner Mrotshowa
p
.002 w
.70408 0 m
.70408 .00625 L
s
P
[(40)] .70408 0 0 2 0 Minner Mrotshowa
p
.002 w
.87415 0 m
.87415 .00625 L
s
P
[(45)] .87415 0 0 2 0 Minner Mrotshowa
p
.001 w
.05782 0 m
.05782 .00375 L
s
P
p
.001 w
.09184 0 m
.09184 .00375 L
s
P
p
.001 w
.12585 0 m
.12585 .00375 L
s
P
p
.001 w
.15986 0 m
.15986 .00375 L
s
P
p
.001 w
.22789 0 m
.22789 .00375 L
s
P
p
.001 w
.2619 0 m
.2619 .00375 L
s
P
p
.001 w
.29592 0 m
.29592 .00375 L
s
P
p
.001 w
.32993 0 m
.32993 .00375 L
s
P
p
.001 w
.39796 0 m
.39796 .00375 L
s
P
p
.001 w
.43197 0 m
.43197 .00375 L
s
P
p
.001 w
.46599 0 m
.46599 .00375 L
s
P
p
.001 w
.5 0 m
.5 .00375 L
s
P
p
.001 w
.56803 0 m
.56803 .00375 L
s
P
p
.001 w
.60204 0 m
.60204 .00375 L
s
P
p
.001 w
.63605 0 m
.63605 .00375 L
s
P
p
.001 w
.67007 0 m
.67007 .00375 L
s
P
p
.001 w
.7381 0 m
.7381 .00375 L
s
P
p
.001 w
.77211 0 m
.77211 .00375 L
s
P
p
.001 w
.80612 0 m
.80612 .00375 L
s
P
p
.001 w
.84014 0 m
.84014 .00375 L
s
P
p
.001 w
.90816 0 m
.90816 .00375 L
s
P
p
.001 w
.94218 0 m
.94218 .00375 L
s
P
p
.001 w
.97619 0 m
.97619 .00375 L
s
P
[(Size of n \\(bits\\))] .5 0 0 2 0 0 -1 Mouter Mrotshowa
p
.002 w
0 0 m
1 0 L
s
P
p
.002 w
0 .06914 m
.00625 .06914 L
s
P
[(0.002)] -0.0125 .06914 1 0 0 Minner Mrotshowa
p
.002 w
0 .17229 m
.00625 .17229 L
s
P
[(0.005)] -0.0125 .17229 1 0 0 Minner Mrotshowa
p
.002 w
0 .25033 m
.00625 .25033 L
s
P
[(0.01)] -0.0125 .25033 1 0 0 Minner Mrotshowa
p
.002 w
0 .32836 m
.00625 .32836 L
s
P
[(0.02)] -0.0125 .32836 1 0 0 Minner Mrotshowa
p
.002 w
0 .43152 m
.00625 .43152 L
s
P
[(0.05)] -0.0125 .43152 1 0 0 Minner Mrotshowa
p
.002 w
0 .50955 m
.00625 .50955 L
s
P
[(0.1)] -0.0125 .50955 1 0 0 Minner Mrotshowa
p
.002 w
0 .58758 m
.00625 .58758 L
s
P
[(0.2)] -0.0125 .58758 1 0 0 Minner Mrotshowa
p
.001 w
0 .11479 m
.00375 .11479 L
s
P
p
.001 w
0 .14717 m
.00375 .14717 L
s
P
p
.001 w
0 .19282 m
.00375 .19282 L
s
P
p
.001 w
0 .21017 m
.00375 .21017 L
s
P
p
.001 w
0 .22521 m
.00375 .22521 L
s
P
p
.001 w
0 .23847 m
.00375 .23847 L
s
P
p
.001 w
0 .37401 m
.00375 .37401 L
s
P
p
.001 w
0 .4064 m
.00375 .4064 L
s
P
p
.001 w
0 .45204 m
.00375 .45204 L
s
P
p
.001 w
0 .4694 m
.00375 .4694 L
s
P
p
.001 w
0 .48443 m
.00375 .48443 L
s
P
p
.001 w
0 .49769 m
.00375 .49769 L
s
P
[(Time \\(seconds\\))] -0.0125 .30902 1 0 90 -1 0 Mouter Mrotshowa
p
.002 w
0 0 m
0 .61803 L
s
P
P
p
p
.002 w
.02381 .61178 m
.02381 .61803 L
s
P
p
.002 w
.19388 .61178 m
.19388 .61803 L
s
P
p
.002 w
.36395 .61178 m
.36395 .61803 L
s
P
p
.002 w
.53401 .61178 m
.53401 .61803 L
s
P
p
.002 w
.70408 .61178 m
.70408 .61803 L
s
P
p
.002 w
.87415 .61178 m
.87415 .61803 L
s
P
p
.001 w
.05782 .61428 m
.05782 .61803 L
s
P
p
.001 w
.09184 .61428 m
.09184 .61803 L
s
P
p
.001 w
.12585 .61428 m
.12585 .61803 L
s
P
p
.001 w
.15986 .61428 m
.15986 .61803 L
s
P
p
.001 w
.22789 .61428 m
.22789 .61803 L
s
P
p
.001 w
.2619 .61428 m
.2619 .61803 L
s
P
p
.001 w
.29592 .61428 m
.29592 .61803 L
s
P
p
.001 w
.32993 .61428 m
.32993 .61803 L
s
P
p
.001 w
.39796 .61428 m
.39796 .61803 L
s
P
p
.001 w
.43197 .61428 m
.43197 .61803 L
s
P
p
.001 w
.46599 .61428 m
.46599 .61803 L
s
P
p
.001 w
.5 .61428 m
.5 .61803 L
s
P
p
.001 w
.56803 .61428 m
.56803 .61803 L
s
P
p
.001 w
.60204 .61428 m
.60204 .61803 L
s
P
p
.001 w
.63605 .61428 m
.63605 .61803 L
s
P
p
.001 w
.67007 .61428 m
.67007 .61803 L
s
P
p
.001 w
.7381 .61428 m
.7381 .61803 L
s
P
p
.001 w
.77211 .61428 m
.77211 .61803 L
s
P
p
.001 w
.80612 .61428 m
.80612 .61803 L
s
P
p
.001 w
.84014 .61428 m
.84014 .61803 L
s
P
p
.001 w
.90816 .61428 m
.90816 .61803 L
s
P
p
.001 w
.94218 .61428 m
.94218 .61803 L
s
P
p
.001 w
.97619 .61428 m
.97619 .61803 L
s
P
p
.002 w
0 .61803 m
1 .61803 L
s
P
p
.002 w
.99375 .06914 m
1 .06914 L
s
P
p
.002 w
.99375 .17229 m
1 .17229 L
s
P
p
.002 w
.99375 .25033 m
1 .25033 L
s
P
p
.002 w
.99375 .32836 m
1 .32836 L
s
P
p
.002 w
.99375 .43152 m
1 .43152 L
s
P
p
.002 w
.99375 .50955 m
1 .50955 L
s
P
p
.002 w
.99375 .58758 m
1 .58758 L
s
P
p
.001 w
.99625 .11479 m
1 .11479 L
s
P
p
.001 w
.99625 .14717 m
1 .14717 L
s
P
p
.001 w
.99625 .19282 m
1 .19282 L
s
P
p
.001 w
.99625 .21017 m
1 .21017 L
s
P
p
.001 w
.99625 .22521 m
1 .22521 L
s
P
p
.001 w
.99625 .23847 m
1 .23847 L
s
P
p
.001 w
.99625 .37401 m
1 .37401 L
s
P
p
.001 w
.99625 .4064 m
1 .4064 L
s
P
p
.001 w
.99625 .45204 m
1 .45204 L
s
P
p
.001 w
.99625 .4694 m
1 .4694 L
s
P
p
.001 w
.99625 .48443 m
1 .48443 L
s
P
p
.001 w
.99625 .49769 m
1 .49769 L
s
P
p
.002 w
1 0 m
1 .61803 L
s
P
P
p
P
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
p
p
.02 w
.02381 .01919 Mdot
.15986 .01472 Mdot
.29592 .06137 Mdot
.43197 .22284 Mdot
.56803 .36961 Mdot
.70408 .46767 Mdot
.84014 .52833 Mdot
.97619 .60332 Mdot
P
P
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{245, 151},
  ImageMargins->{{34, Inherited}, {Inherited, Inherited}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003e0000Ua000`40O003h00OmGoo003eOol00?Eo
o`00UWoo00<007ooOol057oo00<007ooOol0AGoo001TOol9000017oo000000000Woo0`001goo0P00
0Woo10001Goo00<007oo000027oo00@007ooOomoo`<00003Ool0000000H0009oo`<000Aoo`03001o
ogoo04Aoo`00I7oo00@007ooOol0009oo`04001oogooOol20002Ool00`00Oomoo`07Ool01000Oomo
o`000Woo00<007ooOol01Goo00<007oo000027oo00D007ooOomoo`00009oo`04001oogoo0002Ool0
0`00Oomoo`03Ool20004Ool00`00Oomoo`14Ool006Eoo`8000=oo`03001oogoo009oo`800003Ool0
0000008000Ioo`04001oogoo0002Ool00`00Oomoo`05Ool00`00Ool00008Ool01@00Oomoogoo0000
0Woo00@007ooOol0009oo`03001oogoo009oo`03001oogoo00Aoo`03001oogoo04Aoo`00I7oo00D0
07ooOol007oo008000=oo`<0009oo`8000Qoo`80009oo`@000Aoo`@000Qoo`04001oogooOol30002
Ool200000goo000000020002Ool30004Ool00`00Oomoo`14Ool006Aoo`@001Yoo`03001oogoo015o
o`04001oogoo0008Ool00`00Oomoo`08Ool00`00Oomoo`15Ool006Yoo`03001oogoo01Eoo`<001=o
o`8000Eoo`03001oogoo05=oo`00mGoo003eOol00?Eoo`00mGoo003eOol00?Eoo`00mGoo003eOol0
02Ioo`<000=oo`03001oogoo01Uoo`<0009oo`<001Yoo`<000=oo`03001oogoo01Uoo`<0009oo`<0
01aoo`05001oogooOol0000MOol00`00Oomoo`03000MOol002Moo`07001oogooOol007oo00006goo
00<007ooOol00goo00<007ooOol06Woo00H007ooOol007oo000LOol00`00Oomoo`02Ool00`00Oomo
o`0HOol30002Ool00`00Ool0000JOol30004Ool00`00Oomoo`0KOol002Qoo`06001oogoo001oo`00
77oo00<007ooOol00`006goo00L007ooOomoo`00Ool0000KOol01000Oomoogoo0`006Woo00<007oo
00000Woo00<007oo00006Woo00<007oo00000Woo0`007Goo000XOol01P00Oomoo`00Ool001aoo`04
001oogoo000NOol01P00Oomoo`00Ool001aoo`04001oogoo000MOol20002Ool00`00Ool0000KOol2
0002Ool00`00Oomoo`0MOol002Ioo`<000=oo`03001oogoo01Uoo`<0009oo`<001Yoo`<000=oo`03
001oogoo01Uoo`<0009oo`<001aoo`05001oogooOol0000MOol00`00Oomoo`03000MOol00?Eoo`00
mGoo003eOol00?Eoo`009Goob@001goo000UOol00`00Oomoo`02Ool00`00Oomoo`0GOol20006Ool0
0`00Oomoo`0OOol00`00Oomoo`0OOol00`00Oomoo`0OOol00`00Oomoo`0OOol00`00Oomoo`0FOol0
0`00Oomoo`05Ool002Eoo`04001oogooOol2000HOol40005Ool00`0?Oomoo`0OOol00`0?Oomoo`0O
Ool00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0FOol00`00Oomoo`05Ool002Eoo`03001o
ogoo00@001Moo`@000Eoo`0300moogoo01moo`0300moogoo01moo`0300moogoo01moo`0300moogoo
01moo`0300moogoo01Ioo`03001oogoo00Eoo`009Goo00<007ooOol0100067oo0P001Woo00<03goo
Ool07goo00<03gooOol07goo00<03gooOol07goo00<03gooOol07goo00<03gooOol05Woo00<007oo
Ool01Goo000UOol01000Oomoogoo0P008Goo00<03gooOol07goo00<03gooOol07goo00<03gooOol0
7goo00<03gooOol07goo00<03gooOol05Woo00<007ooOol01Goo000UOol00`00Oomoo`0TOol00`0?
Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0FOol00`00
Oomoo`05Ool002Eoo`03001oogoo02Aoo`0300moogoo01moo`0300moogoo01moo`0300moogoo01mo
o`0300moogoo01moo`0300moogoo01Ioo`03001oogoo00Eoo`009Goo00<007ooOol097oo00<03goo
Ool07goo00<03gooOol07goo00<03gooOol07goo00<03gooOol07goo00<03gooOol05Woo00<007oo
Ool01Goo000UOol00`00Oomoo`0TOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol0
0`0?Oomoo`0OOol00`0?Oomoo`0FOol00`00Oomoo`05Ool002Eoo`03001oogoo02Aoo`0300moogoo
015oo`8000aoo`0300moogoo01moo`0300moogoo01moo`0300moogoo01moo`0300moogoo01Ioo`03
001oogoo00Eoo`009Goo00<007ooOol097oo00<03gooOol047oo10002goo00<03gooOol07goo00<0
3gooOol07goo00<03gooOol07goo00<03gooOol05Woo00<007ooOol01Goo000=Ool00`00Oomoo`02
Ool00`00Oomoo`02Ool01@00Oomoogoo00000goo0`000goo00<007ooOol097oo00<03gooOol047oo
10002goo00<03gooOol07goo00<03gooOol07goo00<03gooOol07goo00<03gooOol05Woo00<007oo
Ool01Goo000<Ool00`00Ool00007Ool01`00Ool007oo001oo`0000=oo`03001oogoo009oo`8003T0
3`8008X03`8000Moo`0037oo00<007oo00001goo00L007oo001oo`00Ool00004Ool01@00Oomoogoo
00009Woo00<03gooOol07goo00<03gooOol07goo00<03gooOol07goo00<03gooOol07goo00<03goo
Ool05Woo00<007ooOol01Goo000<Ool00`00Ool00007Ool01`00Ool007oo001oo`0000Aoo`05001o
ogooOol0000VOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol0
0`0?Oomoo`0FOol00`00Oomoo`05Ool000eoo`03001oogoo00Moo`05001oogooOol00003Ool30003
Ool00`00Oomoo`0TOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0O
Ool00`0?Oomoo`0FOol00`00Oomoo`05Ool002Eoo`03001oogoo02Aoo`0300moogoo01moo`0300mo
ogoo01moo`0300moogoo01moo`0300moogoo01moo`0300moogoo01Ioo`03001oogoo00Eoo`009Goo
00<007ooOol097oo00<03gooOol07goo00<03gooOol07goo00<03gooOol07goo00<03gooOol07goo
00<03gooOol05Woo00<007ooOol01Goo000UOol00`00Oomoo`0TOol00`0?Oomoo`0OOol00`0?Oomo
o`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0FOol00`00Oomoo`05Ool002Eoo`03
001oogoo02Aoo`0300moogoo01moo`0300moogoo01moo`0300moogoo01moo`0300moogoo01moo`03
00moogoo01Ioo`03001oogoo00Eoo`009Goo00<007ooOol097oo00<03gooOol07goo00<03gooOol0
7goo00<03gooOol07goo00<03gooOol07goo00<03gooOol05Woo00<007ooOol01Goo000UOol00`00
Oomoo`0TOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?
Oomoo`0FOol00`00Oomoo`05Ool002Eoo`800<D03`8000Moo`009Goo00<007ooOol097oo00<03goo
Ool07goo00<03gooOol07goo00<03gooOol07goo00<03gooOol07goo00<03gooOol05Woo00<007oo
Ool01Goo000UOol00`00Oomoo`0TOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol0
0`0?Oomoo`0OOol00`0?Oomoo`0FOol00`00Oomoo`05Ool002Eoo`03001oogoo02Aoo`0300moogoo
01moo`0300moogoo01moo`0300moogoo01moo`0300moogoo01moo`0300moogoo01Ioo`03001oogoo
00Eoo`009Goo00<007ooOol097oo00<03gooOol07goo00<03gooOol07goo00<03gooOol07goo00<0
3gooOol07goo00<03gooOol05Woo00<007ooOol01Goo000UOol00`00Oomoo`0TOol00`0?Oomoo`0O
Ool00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0FOol00`00Oomoo`05
Ool000Moo`<001]oo`800<D03`8000Moo`0027oo00<007ooOol06Woo00<007ooOol097oo00<03goo
Ool07goo00<03gooOol07goo00<03gooOol07goo00<03gooOol07goo00<03gooOol05Woo00<007oo
Ool01Goo0008Ool00`00Oomoo`0JOol00`00Oomoo`0TOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol0
0`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0FOol00`00Oomoo`05Ool000Ioo`05001oo`00
Ool0000JOol00`00Oomoo`0TOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?
Oomoo`0OOol00`0?Oomoo`0FOol00`00Oomoo`05Ool000Ioo`D0009oo`03001oogoo009oo`03001o
ogoo009oo`05001oogooOol00003Ool30003Ool00`00Oomoo`0TOol00`0?Oomoo`0OOol00`0?Oomo
o`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0FOol00`00Oomoo`05Ool000Ioo`D0
0004Ool007oo0007Ool01`00Ool007oo001oo`0000Aoo`04001oogooOol2003500l20007Ool000Qo
o`07001oogooOol007oo00001goo00L007oo001oo`00Ool00002Ool30003Ool00`00Oomoo`0TOol0
0`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0FOol0
0`00Oomoo`05Ool000Qoo`07001oogooOol007oo00001goo00L007oo001oo`00Ool00002Ool00`00
Oomoo`03Ool00`00Oomoo`0TOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?
Oomoo`0OOol00`0?Oomoo`0FOol00`00Oomoo`05Ool000Moo`8000Aoo`03001oogoo00Moo`05001o
ogooOol00003Ool30003Ool00`00Oomoo`0TOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomo
o`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0FOol00`00Oomoo`05Ool002Eoo`800<D03`8000Moo`00
1Woo00D007oo001oo`0001Yoo`03001oogoo02Aoo`0300moogoo01moo`0300moogoo01moo`0300mo
ogoo01moo`0300moogoo01moo`0300moogoo01Ioo`03001oogoo00Eoo`001Woo00D007oo001oo`00
01Yoo`03001oogoo02Aoo`0300moogoo01moo`0300moogoo01moo`0300moogoo01moo`0300moogoo
01moo`0300moogoo01Ioo`03001oogoo00Eoo`001Woo00D007oo001oo`0001Yoo`03001oogoo02Ao
o`0300moogoo01moo`0300moogoo01moo`0300moogoo01moo`0300moogoo01moo`0300moogoo01Io
o`03001oogoo00Eoo`001Woo1@006Woo0P00a@0?0P001goo000UOol00`00Oomoo`0TOol00`0?Oomo
o`0OOol00`0?Oomoo`0:Ool2000COol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0FOol0
0`00Oomoo`05Ool000Qoo`<001Yoo`03001oogoo02Aoo`0300moogoo01moo`0300moogoo00Uoo`@0
019oo`0300moogoo01moo`0300moogoo01moo`0300moogoo01Ioo`03001oogoo00Eoo`001goo00<0
07ooOol06goo0P00D`0?1000KP0?0P001goo0007Ool4000JOol00`00Oomoo`0TOol00`0?Oomoo`0O
Ool00`0?Oomoo`0:Ool2000COol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0FOol00`00
Oomoo`05Ool000Qoo`8001]oo`800<D03`8000Moo`009Goo00<007ooOol097oo00<03gooOol07goo
00<03gooOol07goo00<03gooOol07goo00<03gooOol07goo00<03gooOol05Woo00<007ooOol01Goo
000AOol00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`030004Ool00`00Oomoo`0TOol00`0?
Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0FOol00`00
Oomoo`05Ool0011oo`03001oo`0000Moo`03001oo`00009oo`03001oogoo00=oo`800<D03`8000Mo
o`0047oo00<007oo00001goo00<007oo00000Woo00<007ooOol00goo00<007ooOol097oo00<03goo
Ool07goo00<03gooOol07goo00<03gooOol07goo00<03gooOol07goo00<03gooOol05Woo00<007oo
Ool01Goo0009Ool00`00Oomoo`04Ool00`00Ool00007Ool00`00Ool00002Ool00`00Oomoo`03Ool0
0`00Oomoo`0TOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol0
0`0?Oomoo`0FOol00`00Oomoo`05Ool000Qoo`03001oogoo00Ioo`03001oogoo00Moo`03001oogoo
008000Eoo`03001oogoo02Aoo`0300moogoo01moo`0300moogoo01moo`0300moogoo01moo`0300mo
ogoo01moo`0300moogoo01Ioo`03001oogoo00Eoo`0027oo00<007ooOol06Woo00<007ooOol097oo
00<03gooOol07goo00<03gooOol07goo00<03gooOol07goo00<03gooOol07goo00<03gooOol05Woo
00<007ooOol01Goo0008Ool00`00Oomoo`0JOol00`00Oomoo`0TOol00`0?Oomoo`0OOol00`0?Oomo
o`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0FOol00`00Oomoo`05Ool000Qoo`03
001oogoo01Yoo`03001oogoo02Aoo`0300moogoo01moo`0300moogoo01moo`0300moogoo01moo`03
00moogoo01moo`0300moogoo01Ioo`03001oogoo00Eoo`002Goo00<007ooOol06Goo00<007ooOol0
97oo00<03gooOol07goo00<03gooOol07goo00<03gooOol07goo00<03gooOol07goo00<03gooOol0
5Woo00<007ooOol01Goo0007Ool3000KOol00`00Oomoo`0TOol00`0?Oomoo`0OOol00`0?Oomoo`0O
Ool00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0FOol00`00Oomoo`05Ool000Qoo`8001]o
o`03001oogoo02Aoo`0300moogoo01moo`0300moogoo01moo`0300moogoo01moo`0300moogoo01mo
o`0300moogoo01Ioo`03001oogoo00Eoo`001goo00<007ooOol06goo00<007ooOol097oo00<03goo
Ool07goo00<03gooOol07goo00<03gooOol07goo00<03gooOol07goo00<03gooOol05Woo00<007oo
Ool01Goo0007Ool3000KOol00`00Oomoo`0TOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomo
o`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0FOol00`00Oomoo`05Ool002Eoo`03001oogoo02Aoo`03
00moogoo01moo`0300moogoo01moo`0300moogoo01moo`0300moogoo01moo`0300moogoo01Ioo`03
001oogoo00Eoo`0027oo0`006Woo00<007ooOol097oo00<03gooOol07goo00<03gooOol07goo00<0
3gooOol07goo00<03gooOol07goo00<03gooOol05Woo00<007ooOol01Goo0007Ool00`00Oomoo`07
Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`030004Ool00`00Oomoo`0TOol00`0?Oomo
o`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0FOol00`00Oomo
o`05Ool000Moo`@000Eoo`03001oo`0000Moo`03001oo`00009oo`03001oogoo00=oo`800<D03`80
00Moo`0027oo0P001Woo00<007oo00001goo00<007oo00000goo00<007ooOol00Woo00<007ooOol0
97oo00<03gooOol07goo00<03gooOol07goo00<03gooOol07goo00<03gooOol07goo00<03gooOol0
5Woo00<007ooOol01Goo000@Ool00`00Ool00007Ool00`00Ool00003Ool00`00Oomoo`02Ool00`00
Oomoo`0TOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?
Oomoo`0FOol00`00Oomoo`05Ool000Qoo`8000Moo`03001oogoo00Moo`03001oogoo00<000Aoo`03
001oogoo02Aoo`0300moogoo01moo`0300moogoo01moo`0300moogoo01moo`0300moogoo01moo`03
00moogoo01Ioo`03001oogoo00Eoo`001goo00@007ooOol001Yoo`03001oogoo02Aoo`0300moogoo
01moo`0300moogoo01moo`0300moogoo01moo`0300moogoo01moo`0300moogoo01Ioo`03001oogoo
00Eoo`001goo00@007ooOol001Yoo`03001oogoo02Aoo`0300moogoo01moo`0300moogoo01moo`03
00moogoo01moo`0300moogoo01moo`0300moogoo01Ioo`03001oogoo00Eoo`0027oo0`006Woo00<0
07ooOol097oo00<03gooOol07goo00<03gooOol07goo00<03gooOol07goo00<03gooOol07goo00<0
3gooOol05Woo00<007ooOol01Goo0008Ool2000KOol00`00Oomoo`0TOol00`0?Oomoo`0OOol00`0?
Oomoo`0OOol00`0?Oomoo`03Ool2000JOol00`0?Oomoo`0OOol00`0?Oomoo`0FOol00`00Oomoo`05
Ool000Moo`04001oogoo000JOol00`00Oomoo`0TOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?
Oomoo`02Ool4000IOol00`0?Oomoo`0OOol00`0?Oomoo`0FOol00`00Oomoo`05Ool000Moo`04001o
ogoo000JOol2001^00l4001C00l20007Ool000Qoo`8001]oo`03001oogoo02Aoo`0300moogoo01mo
o`0300moogoo01moo`0300moogoo00=oo`8001Yoo`0300moogoo01moo`0300moogoo01Ioo`03001o
ogoo00Eoo`009Goo00<007ooOol097oo00<03gooOol07goo00<03gooOol07goo00<03gooOol07goo
00<03gooOol07goo00<03gooOol05Woo00<007ooOol01Goo0007Ool00`00Ool0000KOol00`00Oomo
o`0TOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomo
o`0FOol00`00Oomoo`05Ool000Moo`03001oo`0001]oo`03001oogoo02Aoo`0300moogoo01moo`03
00moogoo01moo`0300moogoo01moo`0300moogoo01moo`0300moogoo01Ioo`03001oogoo00Eoo`00
1goo00<007oo00006goo00<007ooOol097oo00<03gooOol07goo00<03gooOol07goo00<03gooOol0
7goo00<03gooOol07goo00<03gooOol05Woo00<007ooOol01Goo0006Ool4000KOol00`00Oomoo`0T
Ool00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0F
Ool00`00Oomoo`05Ool002Eoo`800<D03`8000Moo`0027oo0`006Woo00<007ooOol097oo00<03goo
Ool07goo00<03gooOol07goo00<03gooOol07goo00<03gooOol07goo00<03gooOol05Woo00<007oo
Ool01Goo0007Ool01000Oomoo`006Woo00<007ooOol097oo00<03gooOol07goo00<03gooOol07goo
00<03gooOol07goo00<03gooOol07goo00<03gooOol05Woo00<007ooOol01Goo0007Ool01000Oomo
o`006Woo00<007ooOol097oo00<03gooOol07goo00<03gooOol07goo00<03gooOol07goo00<03goo
Ool07goo00<03gooOol05Woo00<007ooOol01Goo0008Ool30006Ool00`00Oomoo`02Ool00`00Oomo
o`02Ool00`00Oomoo`030004Ool00`00Oomoo`0TOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?
Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0FOol00`00Oomoo`05Ool000Yoo`03001oogoo00=o
o`03001oo`0000Moo`03001oo`0000=oo`03001oogoo009oo`800<D03`8000Moo`001goo10001Goo
00<007oo00001goo00@007oo001oo`<000Aoo`03001oogoo02Aoo`0300moogoo01moo`0300moogoo
01moo`0300moogoo01moo`0300moogoo01moo`0300moogoo01Ioo`03001oogoo00Eoo`0027oo0P00
1Woo00<007oo00001goo00D007oo001oo`0000Ioo`03001oogoo02Aoo`0300moogoo01moo`0300mo
ogoo01moo`0300moogoo01moo`0300moogoo01moo`0300moogoo01Ioo`03001oogoo00Eoo`001goo
00<007ooOol01goo00<007ooOol01goo00<007ooOol00`0017oo00<007ooOol097oo00<03gooOol0
7goo00<03gooOol07goo00<03gooOol07goo00<03gooOol07goo00<03gooOol05Woo00<007ooOol0
1Goo0007Ool3000KOol2003500l20007Ool000Qoo`03001oogoo01Yoo`03001oogoo02Aoo`0300mo
ogoo01moo`0300moogoo01moo`0300moogoo01moo`0300moogoo01moo`0300moogoo01Ioo`03001o
ogoo00Eoo`002Goo00<007ooOol06Goo00<007ooOol097oo00<03gooOol07goo00<03gooOol07goo
00<03gooOol07Woo0P008Goo00<03gooOol05Woo00<007ooOol01Goo0009Ool00`00Oomoo`0IOol0
0`00Oomoo`0TOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0MOol4000POol00`0?Oomo
o`0FOol00`00Oomoo`05Ool000Uoo`03001oogoo01Uoo`8008T03`@003P03`8000Moo`002Goo00<0
07ooOol06Goo00<007ooOol097oo00<03gooOol07goo00<03gooOol07goo00<03gooOol07Woo0P00
8Goo00<03gooOol05Woo00<007ooOol01Goo0008Ool00`00Oomoo`0JOol00`00Oomoo`0TOol00`0?
Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0FOol00`00
Oomoo`05Ool002Eoo`800<D03`8000Moo`009Goo00<007ooOol097oo00<03gooOol07goo00<03goo
Ool07goo00<03gooOol07goo00<03gooOol07goo00<03gooOol05Woo00<007ooOol01Goo000UOol2
003500l20007Ool002Eoo`03001oogoo02Aoo`0300moogoo01moo`0300moogoo01moo`0300moogoo
01moo`0300moogoo01moo`0300moogoo01Ioo`03001oogoo00Eoo`005Woo00<007ooOol00Woo00@0
07ooOomoo`<000=oo`03001oogoo02Aoo`0300moogoo01moo`0300moogoo01moo`0300moogoo01mo
o`0300moogoo01moo`0300moogoo01Ioo`03001oogoo00Eoo`005Goo00<007oo000027oo00<007oo
Ool00Woo0P00a@0?0P001goo000EOol00`00Ool00008Ool00`00Oomoo`02Ool00`00Oomoo`0TOol0
0`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0FOol0
0`00Oomoo`05Ool001Eoo`03001oo`0000Qoo`03001oogoo009oo`03001oogoo02Aoo`0300moogoo
01moo`0300moogoo01moo`0300moogoo01moo`0300moogoo01Qoo`8000Eoo`0300moogoo01Ioo`03
001oogoo00Eoo`005Woo00<007ooOol01Woo0P0017oo00<007ooOol097oo00<03gooOol07goo00<0
3gooOol07goo00<03gooOol07goo00<03gooOol05goo100017oo00<03gooOol05Woo00<007ooOol0
1Goo000UOol00`00Oomoo`0TOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?
Oomoo`0GOol40004Ool00`0?Oomoo`0FOol00`00Oomoo`05Ool002Eoo`03001oogoo02Aoo`0300mo
ogoo01moo`0300moogoo01moo`0300moogoo01moo`0300moogoo01Qoo`8000Eoo`0300moogoo01Io
o`03001oogoo00Eoo`009Goo00<007ooOol097oo00<03gooOol07goo00<03gooOol07goo00<03goo
Ool07goo00<03gooOol07goo00<03gooOol05Woo00<007ooOol01Goo000UOol00`00Oomoo`0TOol0
0`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0FOol0
0`00Oomoo`05Ool002Eoo`03001oogoo02Aoo`0300moogoo01moo`0300moogoo01moo`0300moogoo
01moo`0300moogoo01moo`0300moogoo01Ioo`03001oogoo00Eoo`009Goo00<007ooOol097oo00<0
3gooOol07goo00<03gooOol07goo00<03gooOol07goo00<03gooOol07goo00<03gooOol05Woo00<0
07ooOol01Goo000UOol00`00Oomoo`0TOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0O
Ool00`0?Oomoo`0OOol00`0?Oomoo`0FOol00`00Oomoo`05Ool002Eoo`03001oogoo02Aoo`0300mo
ogoo01moo`0300moogoo01moo`0300moogoo01moo`0300moogoo01moo`0300moogoo01Ioo`03001o
ogoo00Eoo`009Goo00<007ooOol097oo00<03gooOol07goo00<03gooOol07goo00<03gooOol07goo
00<03gooOol07goo00<03gooOol05Woo00<007ooOol01Goo000UOol00`00Oomoo`0TOol00`0?Oomo
o`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0FOol00`00Oomo
o`05Ool001Ioo`03001oogoo009oo`04001oogooOol30003Ool00`00Oomoo`0TOol00`0?Oomoo`0O
Ool00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0FOol00`00Oomoo`05
Ool001Eoo`03001oo`0000Qoo`03001oogoo009oo`800<D03`8000Moo`005Goo00<007oo00002Goo
00D007ooOomoo`0002Ioo`0300moogoo01moo`0300moogoo01moo`0300moogoo01moo`0300moogoo
01moo`0300moogoo01Ioo`03001oogoo00Eoo`005Goo00<007oo00002Goo00D007ooOomoo`0002Io
o`0300moogoo01moo`0300moogoo01moo`0300moogoo01moo`0300moogoo01moo`0300moogoo015o
o`8000=oo`03001oogoo00Eoo`005Woo00<007ooOol01Woo0`000goo00<007ooOol097oo00<03goo
Ool07goo00<03gooOol07goo00<03gooOol07goo00<03gooOol07goo00<03gooOol047oo10000Woo
00<007ooOol01Goo000UOol00`00Oomoo`0TOol00`0?Oomoo`0OOol00`0?Oomoo`0OOol00`0?Oomo
o`0OOol00`0?Oomoo`0OOol00`0?Oomoo`0@Ool40002Ool00`00Oomoo`05Ool002Eoo`03001oogoo
009oo`03001oogoo01moo`03001oogoo01moo`03001oogoo01moo`03001oogoo01moo`03001oogoo
01moo`03001oogoo015oo`8000=oo`03001oogoo00Eoo`009Goob@001goo0000\
\>"],
  ImageRangeCache->{{{0, 244}, {150, 0}} -> {13.7882, -3.47028, 0.146968, 
  0.0192842}}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Code hidden here ...", "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["\<\
Needs[\"Graphics`Graphics`\"];

PlotTimeToFactorInteger[minBits_, maxBits_, stepSize_, samples_:1000]:=
\tModule[{none},
\t\tdata = Table[AverageTimeToFactorNBitInteger[n], 
\t\t             {n, minBits, maxBits, stepSize}];
\t\tFitSubExponential[data];
\t\tFitExponential[data];
\t\tLogListPlot[data,
\t\t         PlotRange->All,
\t\t         PlotStyle->PointSize[0.02],
\t\t         Frame->True,
\t\t         FrameLabel->{\"Size of n (bits)\", \"Time (seconds)\", \
\"\",\"\"},
\t\t         GridLines->Automatic]
\t]
\t            \
\>", "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[BoxData[
    \(General::"spell1" \( : \ \) 
      "Possible spelling error: new symbol name \"\!\(none\)\" is similar to \
existing symbol \"\!\(None\)\"."\)], "Message"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Fit a Sub-exponential to the data i.e. data ~ exp(x^(1/3) \
(ln(x))^(2/3))\
\>", "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
FitSubExponential[data_]:=
\tModule[{logData},
\t    Clear[x];
\t    xVals = Map[#[[1]]&, data];
\t\tlogData = Map[{#[[1]], Log[#[[2]]]}&, data];
\t\tformula = Fit[logData, {1, x^(1/3) Log[x]^(2/3)}, x];
\t\t
\t\tShow[Plot[Exp[formula], {x, Min[xVals], Max[xVals]},
\t\t          PlotStyle->{{AbsoluteThickness[2], Dashing[{0.02,0.02}], \
GrayLevel[0.7]}},
\t\t          DisplayFunction->Identity],
\t\t     ListPlot[data, 
\t\t              PlotStyle->PointSize[0.02],
\t\t              DisplayFunction->Identity],
\t\t     Frame->True,
\t\t     FrameLabel->{\"Size of n (bits)\", \"Time (seconds)\"},
\t\t     GridLines->Automatic,
\t\t     DisplayFunction :> $DisplayFunction]
\t]
\t\
\>", "Input",
  InitializationCell->True,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Fit an exponential to the data i.e. data ~ exp(x) ", "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
FitExponential[data_]:=
\tModule[{logData},
\t    Clear[x];
\t    xVals = Map[#[[1]]&, data];
\t\tlogData = Map[{#[[1]], Log[#[[2]]]}&, data];
\t\tformula = Fit[logData, {1, x}, x];
\t\t
\t\tShow[Plot[Exp[formula], {x, Min[xVals], Max[xVals]},
\t\t          PlotStyle->{{AbsoluteThickness[2], Dashing[{0.02,0.02}], \
GrayLevel[0]}},
\t\t          DisplayFunction->Identity],
\t\t     ListPlot[data, 
\t\t              PlotStyle->PointSize[0.02],
\t\t              DisplayFunction->Identity],
\t\t     Frame->True,
\t\t     FrameLabel->{\"Size of n (bits)\", \"Time (seconds)\"},
\t\t     GridLines->Automatic,
\t\t     DisplayFunction:>$DisplayFunction]
\t]\
\>", "Input",
  InitializationCell->True,
  AspectRatioFixed->True]
}, Closed]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 640}, {0, 460}},
AutoGeneratedPackage->Automatic,
WindowToolbars->{},
CellGrouping->Manual,
WindowSize->{520, 365},
WindowMargins->{{4, Automatic}, {Automatic, 16}},
PrintingCopies->1,
PrintingPageRange->{1, Automatic},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, -1}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
MacintoshSystemPageSetup->"\<\
00<0004/0B`000002n88o?mooh<<H`Ui0fL5:0?l0080004/0B`000000]P2:001
0000I00000400`<300000BL?00400@BU_l0000000000060801T1T000000@0000
00000000004000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 130, 3, 136, "Title",
  Evaluatable->False],
Cell[1864, 56, 108, 3, 53, "Subsubtitle",
  Evaluatable->False],
Cell[1975, 61, 81, 2, 25, "Input",
  InitializationCell->True],
Cell[2059, 65, 23966, 1092, 159, 7216, 879, "GraphicsData", 
"PostScript", "Graphics",
  Evaluatable->False],
Cell[26028, 1159, 246, 7, 46, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[26299, 1170, 102, 3, 50, "Section",
  Evaluatable->False],
Cell[26404, 1175, 905, 19, 222, "Text",
  Evaluatable->False]
}, Open  ]],

Cell[CellGroupData[{
Cell[27346, 1199, 92, 2, 50, "Section",
  Evaluatable->False],
Cell[27441, 1203, 470, 9, 78, "Text",
  Evaluatable->False],
Cell[27914, 1214, 107, 2, 30, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[28046, 1220, 57, 1, 25, "Input"],
Cell[28106, 1223, 136, 2, 37, "Print"]
}, Open  ]],
Cell[28257, 1228, 121, 2, 30, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[28403, 1234, 80, 2, 42, "Subsubsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[28508, 1240, 73, 1, 25, "Input"],
Cell[28584, 1243, 187, 7, 24, "Output",
  Evaluatable->False]
}, Open  ]],
Cell[28786, 1253, 536, 18, 48, "Text",
  Evaluatable->False]
}, Open  ]],

Cell[CellGroupData[{
Cell[29359, 1276, 123, 2, 42, "Subsubsection",
  Evaluatable->False],
Cell[29485, 1280, 150, 5, 70, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[29672, 1290, 80, 2, 28, "Subsubsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[29777, 1296, 80, 1, 25, "Input"],
Cell[29860, 1299, 176, 8, 31, "Output",
  Evaluatable->False]
}, Open  ]],
Cell[30051, 1310, 98, 2, 30, "Text",
  Evaluatable->False]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[30198, 1318, 87, 2, 50, "Section",
  Evaluatable->False],
Cell[30288, 1322, 467, 16, 48, "Text",
  Evaluatable->False],
Cell[30758, 1340, 136, 5, 38, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[30919, 1349, 80, 2, 42, "Subsubsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[31024, 1355, 92, 1, 25, "Input"],
Cell[31119, 1358, 124, 6, 24, "Output",
  Evaluatable->False]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[31304, 1371, 93, 2, 50, "Section",
  Evaluatable->False],
Cell[31400, 1375, 201, 5, 46, "Text",
  Evaluatable->False],
Cell[31604, 1382, 132, 5, 38, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[31761, 1391, 80, 2, 42, "Subsubsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[31866, 1397, 63, 1, 25, "Input"],
Cell[31932, 1400, 116, 6, 24, "Output",
  Evaluatable->False]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[32109, 1413, 101, 2, 50, "Section",
  Evaluatable->False],
Cell[32213, 1417, 140, 5, 38, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[32378, 1426, 80, 2, 42, "Subsubsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[32483, 1432, 64, 1, 25, "Input"],
Cell[32550, 1435, 114, 6, 24, "Output",
  Evaluatable->False]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[32713, 1447, 80, 2, 42, "Subsubsection",
  Evaluatable->False],
Cell[32796, 1451, 101, 2, 30, "Text",
  Evaluatable->False],
Cell[32900, 1455, 259, 8, 90, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[33184, 1467, 77, 1, 25, "Input"],
Cell[33264, 1470, 140, 7, 24, "Output",
  Evaluatable->False]
}, Open  ]],
Cell[33419, 1480, 204, 6, 46, "Text",
  Evaluatable->False]
}, Open  ]],

Cell[CellGroupData[{
Cell[33660, 1491, 80, 2, 42, "Subsubsection",
  Evaluatable->False],
Cell[33743, 1495, 228, 6, 46, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[33996, 1505, 84, 1, 25, "Input"],

Cell[CellGroupData[{
Cell[34105, 1510, 25699, 1065, 159, 7139, 831, "GraphicsData", 
"PostScript", "Graphics",
  Evaluatable->False],
Cell[59807, 2577, 26243, 1122, 159, 7590, 887, "GraphicsData", 
"PostScript", "Graphics",
  Evaluatable->False],
Cell[86053, 3701, 24505, 1064, 159, 7159, 845, "GraphicsData", 
"PostScript", "Graphics",
  Evaluatable->False]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[110619, 4772, 93, 2, 42, "Subsubsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[110737, 4778, 612, 20, 70, "Input",
  InitializationCell->True],
Cell[111352, 4800, 175, 3, 70, "Message"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[111576, 4809, 155, 5, 28, "Subsubsection",
  Evaluatable->False],
Cell[111734, 4816, 765, 23, 70, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[112536, 4844, 123, 2, 28, "Subsubsection",
  Evaluatable->False],
Cell[112662, 4848, 736, 22, 70, "Input",
  InitializationCell->True]
}, Closed]]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

